/*
 * allow up to 64 acoustic surfaces and 64 speakers
 *
 * in this implementation to make the calculations efficient, we have always
 * assumed a 4 surface room, but we can have as many speakers as we want on that * four spaces
 */
#define	SP_MAX_CHANNEL		64
#define	SP_MAX_SURFACE		4
#define	SP_MAX_SRATE		176000
typedef struct  space_room {
	int	spr_NLs;		/* Number of listening surfaces */
	int   	spr_NAs;		/* Number of acoustic space surfaces */
	float	spr_Lx[SP_MAX_SURFACE];	/* Listening space x-coordinates */
	float	spr_Ly[SP_MAX_SURFACE];	/* Listening space y-coordinates */
	float	spr_Ax[SP_MAX_SURFACE];	/* Acoustic space x-coordinates */
	float	spr_Ay[SP_MAX_SURFACE];	/* Acoustic space y-coordinates */
	int	spr_ns;		/* number of speakers */
	float	spr_Sx[SP_MAX_CHANNEL];	/* Speaker x-coordinates */
	float	spr_Sy[SP_MAX_CHANNEL];	/* Speaker y-coordinates */
				/* negative delay for inner phantom speakers */
	double	spr_Sdelay[SP_MAX_CHANNEL];
	float	spr_TH;			/* diffraction threshhold */
	float	spr_CF;			/* crossface factor */
	/*
	 * precompute data for getcut()
	 */
	float	spr_lx1[SP_MAX_SURFACE];
	float	spr_ly1[SP_MAX_SURFACE];
	float	spr_lx2[SP_MAX_SURFACE];
	float	spr_ly2[SP_MAX_SURFACE];
	int	spr_horiz[SP_MAX_SURFACE], spr_vert[SP_MAX_SURFACE];
	float	spr_m[SP_MAX_SURFACE], spr_b[SP_MAX_SURFACE];
	int	spr_notfirst;
	/*
	 * precompute data for getrefl()
	 */
	double	spr_d[SP_MAX_SURFACE];
	double	spr_sint[SP_MAX_SURFACE];
	double	spr_cost[SP_MAX_SURFACE];
	double	spr_rho[SP_MAX_SURFACE];
	double	spr_sin2t[SP_MAX_SURFACE];
	double	spr_cos2t[SP_MAX_SURFACE];
	double	spr_f1[SP_MAX_SURFACE], spr_f2[SP_MAX_SURFACE];
} t_space_room;

typedef struct _space_tilde
{
	t_object sp_obj;
	t_float  sp_f;		/* save value for control to signal change */
	int	sp_off;		/* have we turned off space */
	/* 
	 int	sp_inputcopy;
	 * with the way the space unit generator in written currently
	 * we do not need to do any copying of the input as the out
	 * samples are calculated and written out one by one
	 */
	t_float *sp_in;		/* the input buffer */
	t_float **sp_out;	/* output buffers */
	t_float *sp_grev;	/* global reverb */
	double	sp_srate;	/* sampling rate */
	int	sp_nchan;	/* number of channels */
	int	sp_vsize;	/* vector size  */
	int	sp_firstbuf;	/* processing the first buf after init? */
	int	sp_interpol;	/* to interpolate or not, that is the qstn */

	/*
	 * room information
	 */
	t_space_room *sp_room;	/* room dimensions */
	int	sp_nir;	/* number of inner rooms defined */
	int	sp_cr_idx;	/* current room index */
	float	sp_direct;	/* direct attenuation */
	float	sp_reflect;	/* reflection attenuation */

	float	sp_innersize;	/* inner room size */
	float	sp_outersize;	/* outer room size */
	int	sp_realray;	/* if set real-time data for theta and back */
	float	sp_back;	/* back scalar value */
	float	sp_theta;	/* theta scalar value */

		/* do not change the name of the following variables
		 * they chosen this way to match the way varialbles
		 * are accessed in space unit generator of cmusic
		 */
	t_float *DBUF;		/* delay buffer */
	long     DLEN;		/* delay buffer length */
	long     NOW;
		/*
		 * the following array should all be
		 * float ***, but to keep compatible with
		 * cmusic we are defining them as float *
		 */
	t_float *CARRAYO;	/* old cut values */
	t_float *DARRAYO;	/* old delay values */
	t_float *AARRAYO;	/* old atten values */
				/*
				 * SDY There seems to be no need to 
				 * keep the old FARRAY or CARRAY
				 */

	t_float *DARRAY;	/* delay values */
	t_float *CARRAY;	/* cut values */
	t_float *AARRAY;	/* atten values */
	t_float *FARRAY;	/* fade in on cut changes */
	t_float *XS;		/* save X location */
	t_float *YS;		/* save y location */
	t_float *THETAS;	/* save THETA */
	t_float *AMPS;		/* save AMP */
	t_float *BACKS;		/* save BACK */
	t_float *X;
	t_float *Y;
	t_float *THETA;
	t_float *AMP;
	t_float *BACK;
} t_space_tilde;

extern void space_init(t_space_tilde *x);
extern void space_free(t_space_tilde *x);
extern void space (t_space_tilde *x);

#define	SP_DEFAULT_INNER	5.0
#define	SP_DEFAULT_OUTER	50.0
#define	SP_DEFAULT_QUAT		4
#define	SP_DEFAULT_STEREO	2

#define SPR_DEFAULT_TH		0.4
#define SPR_DEFAULT_CF		0.5

