/*
 * space~ -- space object for Pd
 *           this code is a port of the space unit generator which was written
 *           by F. Richard Moore as part of the cmusic program in the
 *           CARL package
 *
 * --Shahrokh Yadegari March 2000.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "m_pd.h"
#include "space~.h"

static char *space_version =
			"Space~: Version 0.5alpha, under GNU's GPL License";
static t_class *space_tilde_class;
static char usage[] = "space~ [card] [stereo|quad] inner-size outersize";

int space_mkroom(t_space_tilde *x);

static void *
space_tilde_new(t_symbol *s, int ac, t_atom*av)
{
	int i;
	t_space_tilde *x = (t_space_tilde *) pd_new(space_tilde_class);



	/* assume no real-time radiance info unless noted */
	x->sp_realray = 0;	
	x->sp_back = 1;		/* assume a ful back radiance */
	x->sp_theta = 0;
	x->sp_nchan = 0;
	x->sp_direct = 1.;	/* Direct path distance amplifier */
	x->sp_reflect = 1.;	/* Reflected path distance amplifier */

def:
	if (!ac) {
		/* no arguments so all  set to default quad */
		x->sp_innersize = SP_DEFAULT_INNER;
		x->sp_outersize = SP_DEFAULT_OUTER;
		if (!x->sp_nchan)
			x->sp_nchan = 4;

		goto configdone;
	}

	if (av->a_type == A_FLOAT) {
		if (ac != 2 || av[1].a_type != A_FLOAT) {
			post(usage);
			return ((void *) NULL);
		}
		x->sp_innersize = atom_getfloat(av);
		x->sp_outersize = atom_getfloat(++av);
		if (!x->sp_nchan)
			x->sp_nchan = 4;
		goto configdone;
	}
	if (*atom_getsymbol(av)->s_name == '@') {
		x->sp_nir = atoi(&atom_getsymbol(av)->s_name[1]);
		ac--; av++;
		goto def;
	}
	if (!strcmp (atom_getsymbol(av)->s_name, "card")) {
		x->sp_realray = 1; /* we will have real-time radiance info */
		ac--; av++;
		goto def;
	}
	if (!strcmp (atom_getsymbol(av)->s_name, "stereo")) {
			x->sp_nchan = 2;
			ac--; av++;
			goto def;
	}
	if (!strcmp (atom_getsymbol(av)->s_name, "quad")) {
			x->sp_nchan = 4;
			ac--; av++;
			goto def;
	}
	post(usage);
	return ((void *) NULL);
	
configdone:
// SDY DEL
post("space~: %d speakers, innersize = %f, outersize = %f",	
		x->sp_nchan, x->sp_innersize, x->sp_outersize);
// SDY define the number of inner rooms more meaningfully
	if (!x->sp_nir)
		x->sp_nir = 10;
post("space~: %d inner rooms", x->sp_nir);
	if (space_mkroom(x))
		return ((void *) NULL);
	inlet_new(&x->sp_obj, &x->sp_obj.ob_pd, &s_signal, &s_signal); /*X loc*/
	inlet_new(&x->sp_obj, &x->sp_obj.ob_pd, &s_signal, &s_signal); /*Y loc*/
	if (x->sp_realray) /*THETA*/
		inlet_new(&x->sp_obj, &x->sp_obj.ob_pd, &s_signal, &s_signal);
	inlet_new(&x->sp_obj, &x->sp_obj.ob_pd, &s_signal, &s_signal); /*AMP*/
	if (x->sp_realray) /* BACK */
		inlet_new(&x->sp_obj, &x->sp_obj.ob_pd, &s_signal, &s_signal);

	/* SDY for now assume 44100
	 * but this should be figured out from Pd not from the
	 * signals in space_tilde_dsp
	 */
	x->sp_srate = 44100;
	x->sp_grev = (t_float *) 0;
	/* nchanls output + reverb */
	x->sp_out = (t_float **) malloc(sizeof(t_float *) * (x->sp_nchan + 1));
	if (!x->sp_out) {
		post("space~: malloc failed");
		return ((void *) NULL);
	}
	for (i = 0; i < x->sp_nchan; i++)
		outlet_new(&x->sp_obj, &s_signal);
	outlet_new(&x->sp_obj, &s_signal);	/* global reverb */

	space_init(x);

	return (x);
}

static t_int *
space_tilde_perform(t_int *w)
{
	t_space_tilde *x = (t_space_tilde *)(w[1]);

	if (!x->sp_off)
		space(x);

	return (w+2);
}

static void
space_tilde_dsp(t_space_tilde *x, t_signal **sp)
{
	int i;
	int j = 0;

	dsp_add(space_tilde_perform, 1, x);
	x->sp_srate = sp[0]->s_sr;
	if (x->sp_srate > SP_MAX_SRATE) {
		post("Space~: sample rate > %d is not supported", SP_MAX_SRATE);
		post("Reset SP_MAX_SRATE and recompile the space~ object");
	}
	x->sp_vsize = sp[0]->s_n;
	x->sp_in = sp[j++]->s_vec;
	x->X = sp[j++]->s_vec;
	x->Y = sp[j++]->s_vec;
	x->AMP = sp[j++]->s_vec;
	if (x->sp_realray) /* THETA */
		x->THETA = sp[j++]->s_vec;
	if (x->sp_realray) /* BACK */
		x->BACK = sp[j++]->s_vec;
	for (i = 0; i < x->sp_nchan; i++)
		x->sp_out[i] = sp[i + j]->s_vec;
	x->sp_grev = sp[i + j]->s_vec;
}

static void
space_tilde_free(t_space_tilde *x)
{
	space_free(x);
	free(x->sp_out);
}

static void
space_tilde_interpol(t_space_tilde *x, t_float f)
{
	x->sp_interpol = (f != 0);
	if (x->sp_interpol)
		post("space interpolation on");
	else
		post("space interpolation off");
}


static void
space_tilde_direct(t_space_tilde *x, t_float f)
{
	/* SDY fix the code in ug.space.c to use this. */
	x->sp_direct = f;
printf("space~: Direct = %3.3f\n", f);
}

static void space_tilde_reflect(t_space_tilde *x, t_float f)
{
	/* SDY fix the code in ug.space.c to use this. */
	x->sp_reflect = f;
printf("space~: Reflect = %3.3f\n", f);
}

static void
space_tilde_difth(t_space_tilde *x, t_float f)
{
	int i;

	/* set the diffraction threshold to be the same for all inner rooms */
	for (i = 0; i < x->sp_nir; i++)
		x->sp_room[i].spr_TH = f;
printf("space~: Difraction threshold = %3.3f\n", f);
}

static void
space_tilde_back(t_space_tilde *x, t_float f)
{
	x->sp_back = f;
	post ("set back to %f", f);
}

static void
space_tilde_theta(t_space_tilde *x, t_float f)
{
	post ("set theta to %f", f);
	x->sp_theta = f;
}

static void
space_tilde_difcf(t_space_tilde *x, t_float f)
{
	int i;
	
	/* set the diffraction crossfade to be the same for all inner rooms */
	for (i = 0; i < x->sp_nir; i++)
		x->sp_room[i].spr_CF = f;
		
printf("space~: Difraction curve power = %3.3f\n", f);
}

static void
space_tilde_print(t_space_tilde *x, t_float f)
{
	post("Space:");
	post("	threshhold = %f", x->sp_room[0].spr_TH);
	post("	crossface = %f", x->sp_room[0].spr_CF);
}

static void
space_tilde_debug(t_space_tilde *x, t_float f)
{
	extern int space_debug;


        space_debug = !space_debug;
	printf("space~: debug= %s\n",space_debug ?  "on" : "off");
}

static void
space_tilde_delinterpol(t_space_tilde *x, t_float f)
{
	extern int space_delinterpol;

	space_delinterpol = (int) f;
printf("space~: delinterpol = %d\n", space_delinterpol);
}

static void
space_tilde_stop(t_space_tilde *x)
{
	x->sp_off = 1;
}

static void
space_tilde_start(t_space_tilde *x)
{
	x->sp_off = 0;
}
/*
 * space_tilde_stereo - "stereo inner outer" method
 * set up space with an inner square room with each side = inner
 * and an outer square with each side = outer
 * and locate the speakers at the front corners of the inner room
 */
static void
space_tilde_stereo(t_space_tilde *x, t_float inner, t_float outer)
{
/* SDY */
}

/*
 * space_tilde_quad - "quad inner outer" method
 * set up space with an inner square room with each side = inner
 * and an outer square with each side = outer
 * and locate the speakers at each corner of the inner room
 */
static void
space_tilde_quad(t_space_tilde *x, t_float inner, t_float outer)
{
/* SDY */
}

/*
 * space_tilde_five_1 - "five.1 inner outer" method
 * set up space with an inner rregular pentagon room with each side = inner
 * and an outer square with each side = outer
 * and locate the speakers at each corner of the inner room
 */
static void
space_tilde_five_1(t_space_tilde *x, t_float inner, t_float outer)
{
	post("5.1 diffusion have not been implemented yet");
/* SDY */
}

void
space_tilde_setup(void)
{
	space_tilde_class = class_new(gensym("space~"),
		(t_newmethod)space_tilde_new, (t_method)space_tilde_free,
     	                              sizeof(t_space_tilde), 0, A_GIMME, 0);
	CLASS_MAINSIGNALIN(space_tilde_class, t_space_tilde, sp_f);
	class_addmethod(space_tilde_class, (t_method)space_tilde_dsp,
    							gensym("dsp"), 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_interpol,
	        gensym("interpolate"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_direct,
	        gensym("direct"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_reflect,
	        gensym("reflect"), A_FLOAT, 0);
//	class_addmethod(space_tilde_class, (t_method)space_tilde_quad,
//	        gensym("quad"), A_FLOAT, A_FLOAT, 0);
//	class_addmethod(space_tilde_class, (t_method)space_tilde_stereo,
//	        gensym("stereo"), A_FLOAT, A_FLOAT, 0);
//	class_addmethod(space_tilde_class, (t_method)space_tilde_five_1,
//	        gensym("five.1"), A_FLOAT, A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_theta,
	        gensym("theta"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_theta,
	        gensym("Theta"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_back,
	        gensym("Back"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_back,
	        gensym("back"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_difth,
	        gensym("TH"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_difth,
	        gensym("th"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_difth,
	        gensym("threshold"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_difcf,
	        gensym("CF"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_difcf,
	        gensym("cf"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_difcf,
	        gensym("crossface"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_delinterpol,
	        gensym("delinterpol"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_print,
	        gensym("print"), A_FLOAT, 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_stop,
	        gensym("stop"), 0);
	class_addmethod(space_tilde_class, (t_method)space_tilde_start,
	        gensym("start"), 0);

	post(space_version);
}
