# ***Lila***

**Lila** is a computer music instrument implemented in Pure Data.  The word *Lila* is an old Sanskrit word signifying divine play, the play of destruction and creation, or the play of presence in the moment.  The computer music instrument Lila is built based on simple analog processes (e.g., loop, delay, ring modulation, and feedback) whose parameters are controlled precisely by a performative action. Lila samples and transforms the acoustic material played in real-time
based on the actions of the human playing Lila and plays it back; the acoustic performer can improvise more material on this newly created sound.
This becomes a continual and circular process.
The precise real-time control of the parameters allows the Lila improvisor to participate in both micro and macro level of musical formations.
Thus, the computer not only can act as agent of form in macro structure of time (such as it is in music involving tape music) and lead the acoustic performer,
but also provides a musical context in which a human improvisor, using the computer as an instrument, can accompany and respond to the acoustic material.
In this way, the acoustic performer can have the same form of musical freedom which he or she enjoys in a traditional setting in an augmented expressive language.

Network extensions have been added to Lila so that its performer could control multiple instances of the program over the network,
while Lila compensates for the actions of the performer based on the intrinsic network delays.
I am interested in exploration of the play with space over the network, in the same way that I am able to play with delay in a single location,
to turn the physical distance into an ephemeral yet malleable artistic parameter.

## Installation ##

** Via Git **

git clone --recursive git@gitlab.com:Yadegari/Lila.git

cd Lila

git submodule update --init --recursive

## Theory of Operation ##

**TBD**

## Performing with Lila

In this section the performative interface of Lila is discussed.

### Performing with  Delays
Lila provides 3 separate delay lines each with 3 read heads (instances). The value of each delay can be controlled with either performative actions or through message passing.  By default inputs 1 and 2 are sent to delay line 1; inputs 3 and 4 are sent to delay line 2, and inputs 5 and 6 are sent to delay line 3.

The concept of keyboard control of delays is that a key is pushed to *Mark* the base of a delay line, Then a *Set* key is pushed to set the duration of the delay, which will be the time difference between the *Mark*ing of the delay line and the *Set*ing of it. There are various performatively useful ways to *mark* and *set* the multitude of delay lines.

Six keys are used for each set of controls. One set (keys Q, W, E, A, S, D) is used master set to control all the instances of all the delay lines. One set (Keys R, T, Y, F, G, H) are used to control instances of delay line 1, and another set (keys U, I, O, J, K, L) is used to control the instances of delay line 2. The delay line 3 is only controlled by the master control (because of lack of space on the keyboard),  but it is possible to set its values separately through scripting.
<img src="Documentation/Diagrams/LilaControl.png">

Most users will only need to use the master controls. Key "a" is used to mark the base of all the delay lines. Key 'q' will set the duration of read head 1 for all the delay lines. Key 'w' will set the duration of read head 2 for all the delay lines and letter 'e' will set the duration of the read head 3 for all the delay lines. letter 's' will set the value of the delay lines linearly, with the first ready head duration be according to the moment the letter 's' was pushed, and the delay line duration for read head 2 and 3 be twice and three times of the duration of the delay read head 1 respectively.  Letter 'd' the duration of all the delay lines corresponding to the base of each delay read head.

<img src="Documentation/Diagrams/NonShiftControl.png">

Using shift keys, you can set the base for each instance separately. Letter 'Q' (shift q) sets the base of first instances of all delay lines. 'W' sets the base for the 2nd instances of all delay lines, and 'E' sets the base of the 3rd instances of all delay lines. Lila has a single memory for the delay base locations. 'A', swaps the base of all instances of all delay lines with previously set values Letter 'S' (shift 's') arranges the delays geometrically where delay duration of read head 2 is twice the duration of read head 1, and duration of read head 3 is 4 times the duration of read head 1.
<img src="Documentation/Diagrams/ShiftControl.png">


As mentioed above one can set the base and duration of the instances of each delay line separately as well in case the performer chooses to have different delay values for different inputs. Below diagram shows the non-shifted key layout for delay control:

<img src="Documentation/Diagrams/LilaControlFull.png">

Below diagram shows the shift key layout for delay control:

<img src="Documentation/Diagrams/LilaControlFullShift.png">

##Loops##

You can use the page *L_record_loop* in the main Lila page, or one of the midi controllers, which can be configured in the "*L_config* page, to record loops. The two variables *L_quantizeLoop* and *L_quantizeLoopStart* effect the loop recording and playback behavior.

When *L_quantizeLoop* is set the first recorded loop sets the shortest loop duration (in variable *L_loopLength* in number of samples), after that the duration of all recorded loops will be an integer multiple of *LoopLength*. If *L_quantizeLoopStart*, loop recording starts at the shortest loop boundary repeat, and loop play will start at the loop repeat boundary to make sure that all loops share the same common denominator in length and in play back time.

If *L_quantizeLoop* is set but *L_quantizeLoopStart* is not set, the period of loops are regulated as above, however, the recording of loop will happen right at the moment recording is initiated (in interface or by midi instrument) and playback of the respective loop will (re)start once stop recording is requested.


##Recording and Playback of Performances##

Push the Record button, and enter a <filename>. Session recording starts the moment a file is chosen. Click the Start/Stop recording button, to stop recording.The recoding process will create a command file named <filename> and an audio file named <filename>_Lila_audio.wav, which will be a multichannel raw recording of the inputs to Lila (4 Channels in Version 0.7).

To playback a recorded session, load the session by choosing <filename>. After the file is loaded, you can replay the session by pushing the play button. A session can be played back multiple times.

## Programming Lila ##

# **Files**

L_inputpot.pd - 
L_pot_p.pd -  graph on parent pot
L_potl_p.pd - graph o parent logarithmic pot
Lbang.pd - 
Lila-Mammad.pd
Lila.pd
L_btn.pd
L_btnM.pd
pot.pd
pot1.pd
potN.pd
potl.pd
potlM.pd


L_forautomation.pd
L_fornetcom.pd


### messages ###

To be sorted out

** Naming Convention **

<variable>Level<#>   - The RMS level of the <#> voice of the <variable>

| variable |  function |
|----------|-----------|
| L_showPostFaderInputLevel | show poset fader values for inputs |
| L_input_#_vu | RMS level of input# |
| L_setInputChan# | set the dac chan of input #
| L_sigFaderInput#| Post fader signal of input # |
| L_rawInputSig#  | Prefader signal of input # |
| L_inputSig#     | throw~ L_forInputSig will add the signal to prefader signal of input # |
| L_inputOscVol#	| set the oscillator volume for input # |
| L_inputOscFreq#	| set the frequency of the oscillator signal for input # |
| L_inputNoiseVol#	| set the noise volume for input # |

**Volume messages**

Inpt 

```
 master-amp;
 master-lvl;
 mastervol_do;
 mute;
 muteval;
 muting;
 mvol1;
 mvol2;
 mvol3;
 mvol4;
 mvol5;
 mvol6;
 mvol7;

**Input messages**

**Delay messgaes**

NOTE: In Version 0.9 Lila is configured wiht 3 delay lines each of them having 3 delay instances which can be configured separately

L_delay_#n_#m <value>   	set the delay time for the #n instance of the  #m delay line
               				e.g. "L_delay_2_3 100" sets the delay for the 3rd intance of 2nd delay line to 100 milliseconds

L_delay_#n <value>    		set the delay time for the #n instance of all delay lines to <value> milliseconds
               				e.g. "L_delay_1 100" sets the delay for the first intance of all delay lines to 100 milliseconds

-----
Dealy for all delay lines

L_delayBaseAll <bang>		Set the delay base of all instances of all delay line

L_delayBase_All_Swap <Bang>		Swap the base of all instances  of all delay lines to the previous values

L_delaySet_All <bang>			Set the delay value of all the instances of all delay lines
								i.e. L_delay_2 = L_delay_1 = L_delay_3 if all the bases were the same 

L_delaySet_All_Airth <bang>			Set the delay value of all the instances of all delay lines arithmatically
								e.g. when this message is sent the value of all delays are set to arithmatical progressio of instances
								i.e. L_delay_2 = (L_delay_1 * 2) and L_delay_3 = (L_delay_1 * 3)

L_delaySet_All_Geo <bang>			Set the delay value of all the instances of all delay lines geomerically
								e.g. when this message is sent the value of all delays are set to arithmatical progressio of instances
								i.e. L_delay_2 = (L_delay_1 * 2) and L_delay_3 = (L_delay_1 * 4)

L_delaySet_All_Rand <bang>		Set the delay value of all the instances of all delay lines randomly in relation to the moment
								this message is passed (TBD - random measure or random total?)

------


L_delayBase_#n_#m  <bang>  		Set the delay base of #n instances of #m delay line
								e.g. "L_delayBase_2_3 bang" will set the base for the 2nd instance of the 3rd delay line

L_delaySet_#n_#m  <bang>   		Set the delay base of #n instances of #m delay line
								e.g. "L_delayBase_2_3 bang" will set the base for the 2nd instance of the 3rd delay line

L_delayBase_#n <bang> 			Set the delay base of all instances of #n delay line

L_delayBase_#n_Swap <bang> 		Swap the base of all instances  of all delay line #n to the previous values


L_delaySet_#n <bang>			Set the delay value of all the instances of delay linei #n to the same value
								e.g. when this message is sent the value of all delays are set to arithmatical progressio of instances

L_delaySet_#n_Arith <bang>		Set the delay value of all the instances of nth delay line arithmatically
								i.e. L_delay_#1_2 = (L_delay_#1_1 * 2) and L_delay_#1_3 = (L_delay_#1_1 * 3)

L_delaySet_#n_Geo <bang>		Set the delay value of all the instances nth delay line geomerically
								i.e. L_delay_#1_2 = (L_delay_#1_1 * 2) and L_delay_#1_3 = (L_delay_#1_1 * 4)


L_delaySet_#n_Rand <bang>		Set the delay value of all the instances of nth delay line randomly in relation to the moment
								this message is passed (TBD - random measure or random total?)

L_delaySet_All_#n				Set the delay of the nth instances of all delay lines




 netdelayt;
 phrasereset;
 print;
 randecho1;
 randecho2;
 randecho3;
 
 ```
 
 ```
 /DelayBaseGroup;
 /StopDelay;
 /StopDelaySharp;
 /\$1;
 /echo1on;
 /echo2on;
 /echo3on;

 lila_keyinput;
 BCF-midi;
 jlc-midi;
 End-1-4;
 Lila-Remote;
 Lila-Saving;
 Lila-transmit;
 OSC-ctl-back;
 OSC-ctl;
 \$1-change;
 \$1_do;
 \$1;
 \$2;
 console;
 localhost;
 localreset;
 
 conv1vol_do;
 conv2vol_do;
 conv3vol_do;
 conv4vol_do;

 cooked-pitch-for-following;

 curphrase;

 echo0;
 echo0last;
 echo1;
 echo1base;
 echo1del_do;
 echo1fb_do;
 echo1freq_do;
 echo1gate;
 echo1ol;
 echo1vol_do;
 echo2;
 echo2base;
 echo2del_do;
 echo2fb_do;
 echo2freq_do;
 echo2gate;
 echo2ol;
 echo2vol_do;
 echo3;
 echo3base;
 echo3del_do;
 echo3fb_do;
 echo3freq_do;
 echo3gate;
 echo3ol;
 echo3vol_do;
 
 echoall;
 echoalldel;
 echoback;
 echobaseall;
 echostart;
 echostop;

 forautomation;
 fornetsend;
 forsoundfiler;

 freqch1;
 freqch2;
 freqch3;

 hardreset;

 input1noise;
 L_input_\$1_vol_do;
 insamplength2;
 insamplength;
 insamprate2;
 insamprate;

 l2bang;
 l2bangrev;
 l3bang;
 l3bangrev;
 l3end;
 l3low1set;
 l3low2set;
 l3start;
 l3stoplow1;
 l3stoplow2;
 l4bang2;
 l4bang;
 l4bangrev;
 l4end;
 l4low1set;
 l4low2set;
 l4start;
 l4stoplow1;
 l4stoplow2;
 l5bangrev;
 l8bang2;
 l8bang;
 l8bangrev;
 l8end;
 l8start;
 l8stoplow1;
 l8stoplow2;

 l\$1end_do;
 l\$1eqhigh;
 l\$1eqlow;
 l\$1ol;
 l\$1rand;
 l\$1rec;
 l\$1start;
 l\$1stop;
 


 loop1write;
 loop2write;
 loop3low1vol_do;
 loop3low2vol_do;
 loop3write;
 loop4low1vol_do;
 loop4low2vol_do;
 loop4write;
 loop5write;
 loop6write;
 loop7write;
 loop8low1vol_do;
 loop8low2vol_do;
 loop8write;

 loop\$1hp_do;
 loop\$1vol_do;
 loopreset;
 looprestart;
 loopsret_do;


 read-sample1;
 read-sample2;
 read-sample3;
 read-sample4;
 read-sample;
 read-sample\$1;
 remotehost;
 reset;

 section-label;
 section-note;
 section-number;
 section-qlist-number;
 section-reset;
 section-scofo-number;
 section-scofo-right-inlet;
 section-scofo-tutti;
 section-scofo;
 section-start;
 section-step;
 set-\$1;

 setinputchan;
 setoutputchan1;
 setoutputchan2;
 setoutputchan3;
 setoutputchan4;

 sf1-ER-L;
 sf1-celloclmx;
 sf1-lc2;
 sf1-longrums;
 sf1-name;
 sf1-newbase;
 sf1-newbaseend;
 sf1-singsine;
 sf1-start;
 sf1-stop;
 sf1-winbase;
 sf1-winbaseend;
 sf1vol_do;
 sf2-ER-R;
 sf2-celloclmx;
 sf2-lc2;
 sf2-longcello;
 sf2-name;
 sf2-newbaseend;
 sf2-nno;
 sf2-start;
 sf2-stop;
 sf2vol_do;

 sideecho1;

 snd1toinput1_do;
 snd1tov1;
 snd2toinput1_do;
 snd2tov1;

 space1freq_do;
 space1on_do;
 space1sp;
 space1x_do;
 space1xfreq_do;
 space1xphase_do;
 space1y_do;
 space1yfreq_do;
 space1yphase_do;
 space2freq_do;
 space2on_do;
 space2sp;
 space2x_do;
 space2xfreq;
 space2xphase_do;
 space2y_do;
 space2yfreq_do;
 space2yphase_do;
 spatialize_do;
 spaton;
 spatreset;

 spccfg\$1;
 squelch;

 srate;
 L_stereoOnly;

 stopdelay;
 tgp;
 toBCF;

 v1x_do;
 v1x-on1;
 v1x-on2;
 v1xy1;
 v1xy2;
 v1y_do;
 v1y-on1;
 v1y-on2;
 v2x_do;
 v2x-on1;
 v2x-on2;
 v2xy1;
 v2xy2;
 v2y_do;
 v2y-on1;
 v2y-on2;
 v3x_do;
 v3x-on1;
 v3x-on2;
 v3xy1;
 v3xy2;
 v3y_do;
 v3y-on1;
 v3y-on2;
 v4x_do;
 v4x-on1;
 v4x-on2;
 v4xy1;
 v4xy2;
 v4y_do;
 v4y-on1;
 v4y-on2;
 v5x_do;
 v5x-on1;
 v5x-on2;
 v5xy1;
 v5xy2;
 v5y_do;
 v5y-on1;
 v5y-on2;
 v6x_do;
 v6x-on1;
 v6x-on2;
 v6xy1;
 v6xy2;
 v6y_do;
 v6y-on1;
 v6y-on2;
 v7x_do;
 v7x-on1;
 v7x-on2;
 v7xy1;
 v7xy2;
 v7y_do;
 v7y-on1;
 v7y-on2;
 vol1_do;
 vol2_do;
 vol3_do;
 vol4_do;
 vol5_do;
 vol6_do;
 vol7_do;

 window-size;

~ RAWinputsig1;
~ RAWinputsig2;
~ RAWinputsig3;
~ RAWinputsig4;
~ X2;
~ Y2;
~ dac1-a;
~ dac2-a;
~ dac3-a;
~ dac4-a;
~ delinputsig1;
~ inputsig1;
~ inputsig2;
~ inputsig3;

Internal Lila Sends/Recieves

_L_keyIn   Symbold of the pressed key
_L_keyDown   Key up of down. 1 is down, 0 is up
_L_shiftVal		(1, -1) Normally it is 1, and  as long as either Shiftkey is down -1


Internal Lila Variables
```
