#include <math.h>

scopy( out, in, n ) float *out, *in ; int n ; {
 register float *lim = out + n ;
    while ( out < lim )
	*out++ = *in++ ;
}
sscale( out, x, n ) float *out, x ; int n ; {
 register float *lim = out + n, s = x ;
    while ( out < lim )
	*out++ *= s ;
}
sexp( out, p, n ) float *out, p ; int n ; {
 register float *lim = out + n ;
 register double d = p ;
    while ( out < lim )
	*out++ = pow( d, (double) *out ) ;
}
smult( out, a, b, n ) float *out, *a, *b ; int n ; {
 register float *lim = out + n ;
    while ( out < lim )
	*out++ = *a++**b++ ;
}
speak( out, in, n ) float *out, *in ; int n ; {
 register float abs, *lim = in + n ;
    for ( *out = *in < 0. ? -*in : *in ; in < lim ; in++ )
	if ( ( abs = *in < 0. ? -*in : *in ) > *out )
	    *out = abs ;
}
srms( out, in, n ) float *out, *in ; int n ; {
 register float *lim = in + n ;
    for ( *out = 0 ; in < lim ; in++ )
	*out += *in**in ;
    *out /= n ;
    if ( *out >= 0. )
	*out = sqrt( (double) *out ) ;
}
spha( out, in, n ) float *out, *in ; int n ; {
 register float *lim = out + n ;
 register float *re = in ;
 register float *im = in + 1 ;
    for ( ; out < lim ; re += 2, im += 2  )
	if ( *re != 0. )
	    *out++ = atan2( (double) *im, (double) *re ) ;
	else
	    *out++ = 0. ;
}
ssmsq( out, in, n ) float *out, *in ; int n ; {
 register float *lim = out + n ;
 register float *re = in ;
 register float *im = in + 1 ;
    for ( ; out < lim ; re += 2, im += 2  )
	*out++ = *re**re + *im**im ;
}
ssqrt( out, in, n ) float *out, *in ; int n ; {
 register float *lim = out + n ;
    for ( ; out < lim ; out++, in++ )
	if ( *in > 0. )
	    *out = sqrt( (double) *in ) ;
}
sadb( out, in, n ) float *out, *in ; int n ; {
 register float *lim = out + n ;
    for ( ; out < lim ; out++, in++ )
	if ( *in > 0. )
	    *out = 20.*log10( (double) *in ) ;
	else
	    *out = -120. ;
}
spdb( out, in, n ) float *out, *in ; int n ; {
 register float *lim = out + n ;
    for ( ; out < lim ; out++, in++ )
	if ( *in > 0. )
	    *out = 10.*log10( (double) *in ) ;
	else
	    *out = -120. ;
}
sclear( a, n ) float *a ; int n ; {
 float *lim = a + n ;
    while ( a < lim )
	*a++ = 0. ;
}
