#include <stdio.h>
#include <math.h>
#include <usercore.h>
#include "defs.h"
#include "exts.h"

#define THRESH 1.e-10

extern struct dvalue *iterptr ;

float sqx[] = { 1., 0., -1., 0., 1., 0., -1. } ;
float sqy[] = { 0., 1., 0., -1., 1., -1., 1. } ;
float sqz[] = { 0., 0., 0., 0., 0., 0., 0. } ;


make_drawing( fill ) int fill ;  {
 int i ;
 char txt[BUFSIZ] ;
 float smin, smax, x, y, z ;
 double delta, tick, tickstart ;
 static float Lsmin, Lsmax, Lxfm ;
    if ( fp != NULL ) { int err = 0 ;
	if ( begin < 0 ) { errmess( "begin time < 0" ) ; err++ ; }
	if ( wsize < 2 ) { errmess( "window size < 2" ) ; err++ ; }
	if ( skip < 0 ) { errmess( "skip size < 0" ) ; err++ ; }
	if ( niter < 1 ) { 
	    errmess( "iterations < 1" ) ;
	    niter = 1 ;
	    update_val( iterptr ) ;
	    err++ ;
	}
	if ( npoles < 0 ) { errmess( "npoles < 0" ) ; err++ ; }
	if ( npoles > wsize ) { errmess( "npoles too large" ) ; err++ ; }
	if ( dxmax < dxmin ) { errmess( "xmax < xmin" ) ; err++ ; }
	if ( dxmax < 0 ) { errmess( "xmax < 0" ) ; err++ ; }
	if ( dxmin < 0 ) { errmess( "xmin < 0" ) ; err++ ; }
	if ( xfm & POLES && npoles <= 0 ) {
	    errmess( "no poles to plot" ) ; err++ ;
	}
	if ( xfm & SPEC && !( xfm & PRESP ) )  {
	    for ( i = 2 ; ; i <<= 1 )
		if ( i >= wsize )
		    break ;
	    if ( dxmax > i>>1 ) {
		errmess( "xmax too large" ) ; err++ ;
	    }
	} else if ( !( xfm & PRESP ) && dxmax > wsize - 1 ) {
	    errmess( "xmax too large" ) ; err++ ;
	}
	if ( err )
	    goto practice ;

	set_image_transformation_type( XFORM3 ) ;
	set_fill_index( fill ) ;

	create_retained_segment( SKETCH ) ;
	set_segment_visibility( SKETCH, FALSE ) ;
	makedis(
	    fp, srate, begin, wsize, skip, niter, npoles, xfm,
		&smin, &smax
	) ;
	close_retained_segment() ;
	if ( xfm & ZDBSPEC ) {
	    smin -= smax ;
	    smax = 0 ;
	}

	if ( grid_exists ) {
	    delete_retained_segment( GRID1 ) ;
	    delete_retained_segment( GRID2 ) ;
	    delete_retained_segment( GRID3 ) ;
	    delete_retained_segment( GRIDLABEL ) ;
	}
	set_linestyle( DOTTED ) ;

	create_retained_segment( GRID2 ) ;
	set_segment_visibility( GRID2, FALSE ) ;
	if ( xfm & POLES ) {
	} else if ( niter > 1 ) {
	    move_abs_3( -.5, .5, -.5 ) ;
	    line_rel_3( 0., 0., 1. ) ;
	    line_rel_3( 1., 0., 0. ) ;
	    line_rel_3( 0., 0., -1. ) ;
	    move_abs_3( -.5, -.5, .5 ) ;
	    line_rel_3( 1., 0., 0. ) ;
	    move_abs_3( -.5, .5, .5 ) ;
	    line_rel_3( 0., -1., 0. ) ;
	    line_rel_3( 0., 0., -1. ) ;
	    move_abs_3( .5, .5, .5 ) ;
	    line_rel_3( 0., -1., 0. ) ;
	    line_rel_3( 0., 0., -1. ) ;
	}
	close_retained_segment() ;

	if ( xfm & PHASPEC ) { float deg = 180./(4.*atan(1.)) ;
	    smin *= deg ;
	    smax *= deg ;
	}
	create_retained_segment( GRID3 ) ;
	set_segment_visibility( GRID3, FALSE ) ;
	if ( xfm & POLES ) {
	} else {
	    set_tick( smin, smax, &tickstart, &delta ) ;
	    for ( i = 1 ; i < niter ; i++ ) {
		z = i/(niter - 1.) - .5 ;
		for (
		    tick = tickstart ;
		    tick + .25*delta < (double) smax ;
		    tick += delta
		) {
		    if ( fabs( tick ) < THRESH )
			tick = 0 ;
		    move_abs_3( -.5, map(tick,smin,smax,-.5,.5), z ) ;
		    line_rel_3( 1., 0., 0. ) ;
		}
		if ( i < niter - 1 ) {
		    move_abs_3( -.5, .5, z ) ;
		    line_rel_3( 1., 0., 0. ) ;
		}
	    }
	}
	close_retained_segment() ;

	create_retained_segment( GRID1 ) ;
	set_segment_visibility( GRID1, FALSE ) ;
	if ( niter > 1. )
	    z = -.5 ;
	else
	    z = 0. ;
	if ( xfm & POLES ) {
	 double ang, TWOPI = 8.*atan(1.), PI = 4.*atan(1.) ;
	    set_tick( 0., srate/2., &tickstart, &delta ) ;
	    for (
		tick = tickstart ;
		tick + .25*delta < (double) srate/2. ;
		tick += delta
	    ) {
		ang = TWOPI*tick/srate ;
		move_abs_3( .5*cos(ang), .5*sin(ang), z ) ;
		line_abs_3( .5*cos(ang+PI), .5*sin(ang+PI), z ) ;
	    }
	} else {
	    move_abs_3( -.5, .5, z ) ;
	    line_abs_3( -.5, -.5, z ) ;
	    move_abs_3( .5, .5, z ) ;
	    line_abs_3( .5, -.5, z ) ;
	    move_abs_3( -.5, .5, z ) ;
	    line_abs_3( .5, .5, z ) ;
	    move_abs_3( -.5, -.5, z ) ;
	    line_abs_3( .5, -.5, z ) ;
	    for (
		tick = tickstart ;
		tick + .25*delta < (double) smax ;
		tick += delta
	    ) {
		if ( fabs( tick ) < THRESH )
		    tick = 0 ;
		y = map(tick,smin,smax,-.5,.5) ;
		move_abs_3( -.5, y, z ) ;
		line_rel_3( 1., 0., 0. ) ;
	    }
	}
	close_retained_segment() ;

	set_linestyle( SOLID ) ;

	create_retained_segment( GRIDLABEL ) ;
	set_segment_visibility( GRIDLABEL, FALSE ) ;
	if ( xfm & POLES ) {
	    ltext( "0", .55, 0., z ) ;
	    sprintf( txt, "+-%.5g", srate/2. ) ;
	    rtext( txt, -.55, 0., z ) ;
	} else {
	    sprintf( txt, "%.5g", smax ) ;
	    rtext( txt, -.5, .5, z ) ;
	    if ( smin != smax ) {
		if ( niter > 1. )
		    z = -.5 ;
		else
		    z = 0. ;
		sprintf( txt, "%.5g", smin ) ;
		rtext( txt, -.5, -.5, z ) ;
		for (
		    tick = tickstart ;
		    tick + .25*delta < (double) smax ;
		    tick += delta
		) {
		    if ( fabs( tick ) < THRESH )
			tick = 0 ;
		    y = map(tick,smin,smax,-.5,.5) ;
		    sprintf( txt, "%.5g", tick ) ;
		    rtext( txt, -.5, y, z ) ;
		}
		set_charup_2( 1., 0. ) ;
		set_charpath_2( 0., -1. ) ;
		if ( xfm & SPEC || xfm & PRESP ) {
		    for ( i = 2 ; ; i <<= 1 )
			if ( i >= wsize )
			    break ;
		    if ( xfm & PRESP )
			i = npresp<<1 ;
		    sprintf( txt, "%.5g", srate*dxmin/i ) ;
		    move_abs_3( -.5, -.55, z ) ;
		    text( txt ) ;
		    sprintf( txt, "%.5g", srate*dxmax/i ) ;
		    move_abs_3( .5, -.55, z ) ;
		    text( txt ) ;
		    set_tick( srate*dxmin/i, srate*dxmax/i,
			&tickstart, &delta ) ;
		    for (
			tick = tickstart ;
			tick + .25*delta < (double) srate*dxmax/i ;
			tick += delta
		    ) {
			x = map(tick,srate*dxmin/i,srate*dxmax/i,-.5,.5) ;
			move_abs_3( x, -.5, z ) ;
			line_abs_3( x, -.55, z ) ;
		    }
		} else if ( xfm & POLES ) {
		    move_abs_3( -.5, -.55, z ) ;
		    text( "-1" ) ;
		    move_abs_3( .5, -.55, z ) ;
		    text( "1" ) ;
		} else {
		    sprintf( txt, "%.5g", (float) dxmin ) ;
		    move_abs_3( -.5, -.55, z ) ;
		    text( txt ) ;
		    sprintf( txt, "%.5g", (float) dxmax ) ;
		    move_abs_3( .5, -.55, z ) ;
		    text( txt ) ;
		}
		set_charup_2( 0., 1. ) ;
		set_charpath_2( 1., 0. ) ;
	    }
	}
	close_retained_segment() ;

	grid_exists = 1 ;
/*
* generate plot label
*/
	if ( label_exists )
	    delete_retained_segment( LABEL ) ;

	create_retained_segment( LABEL ) ;
	set_segment_visibility( LABEL, FALSE ) ;
	if ( niter > 1. ) {
	    z = -.5 ;
	    set_charpath_3( 0., 0., 1. ) ;
	    ltext( "time ->", .55, -.55, z ) ;
	    set_charpath_3( 1., 0., 0. ) ;
	} else
	    z = 0. ;
	if ( xfm & SPEC || xfm & PRESP )
	    ctext( "frequency ->", 0., -.6, z ) ;
	else if ( xfm & HPSPEC )
	    ctext( "frequency ->", 0., -.6, z ) ;
	else if ( xfm & POLES )
	    ctext( "real ->", 0., -.6, z ) ;
	else
	    ctext( "time ->", 0., -.6, z ) ;
	set_charup_2( -1., 0. ) ; set_charpath_2( 0., 1. ) ;
	if ( xfm & AMPSPEC ) {
	    ctext( "relative", -.75, 0., z ) ;
	    ctext( "amplitude ->", -.7, 0., z ) ;
	} else if ( xfm & POWSPEC ) {
	    ctext( "relative", -.75, 0., z ) ;
	    ctext( "power ->", -.7, 0., z ) ;
	} else if ( xfm & DBSPEC ) {
	    ctext( "relative power", -.75, 0., z ) ;
	    ctext( "in dB ->", -.7, 0., z ) ;
	} else if ( xfm & ZDBSPEC ) {
	    ctext( "relative power", -.75, 0., z ) ;
	    ctext( "normalized to 0 dB ->", -.7, 0., z ) ;
	} else if ( xfm & PHASPEC ) {
	    ctext( "phase angle", -.75, 0., z ) ;
	    ctext( "in degrees ->", -.7, 0., z ) ;
	} else if ( xfm & HPSPEC ) {
	    ctext( "harmonic product ->", -.7, 0., z ) ;
	} else if ( xfm & POLES ) {
	    ctext( "imaginary ->", -.7, .1, z ) ;
	} else if ( xfm & RMS ) {
	    ctext( "r.m.s. amplitude ->", -.7, 0., z ) ;
	} else if ( xfm & PEAK ) {
	    ctext( "peak amplitude ->", -.7, 0., z ) ;
	} else {
	    ctext( "instantaneous", -.75, 0., z ) ;
	    ctext( "amplitude ->", -.7, 0., z ) ;
	}
	set_charup_2( 0., 1. ) ; set_charpath_2( 1., 0. ) ;
	if ( xfm & HAMMING ) {
	    txt[0] = '\0' ;
	    strcat( txt, "Hamming window" ) ;
	    ctext( txt, 0., -.7, z ) ;
	} else
	    ctext( "rectangular window", 0., -.7, z ) ;
	if ( npoles ) {
	    sprintf( txt, "%d-pole linear prediction", npoles ) ;
	    ctext( txt, 0., -.8, z ) ;
	}
	close_retained_segment() ;

	set_image_transformation_type( NONE ) ;
	label_exists = 1 ;

    } else {
     practice:

	set_image_transformation_type( XFORM3 ) ;

	create_retained_segment( SKETCH ) ;
	set_segment_visibility( SKETCH, FALSE ) ;
	set_linestyle( DOTTED ) ;
	move_abs_3( -.55, 0., 0. ) ;
	line_abs_3( .55, 0., 0. ) ;
	text( "X" ) ;
	move_abs_3( 0., -.55, 0. ) ;
	line_abs_3( 0., .55, 0. ) ;
	text( "Y" ) ;
	move_abs_3( 0., 0., -.55 ) ;
	line_abs_3( 0., 0., .55 ) ;
	text( "Z" ) ;
	set_linestyle( SOLID ) ;
/* when polygons are used, draw in reverse */
	for ( i = 0 ; i < niter ; i++ ) {
	    if ( niter > 1. )
		move_abs_3( -.5,  -.5,  i/(niter - 1.) - .5 ) ;
	    else
		move_abs_3( -.5,  -.5,  0. ) ;
	    polyline_rel_3( sqx, sqy, sqz, 7 ) ;
	}
	close_retained_segment() ;
	if ( grid_exists ) {
	    delete_retained_segment( GRID1 ) ;
	    delete_retained_segment( GRID2 ) ;
	    delete_retained_segment( GRID3 ) ;
	    delete_retained_segment( GRIDLABEL ) ;
	}
	if ( label_exists )
	    delete_retained_segment( LABEL ) ;
	create_retained_segment( GRID1 ) ; close_retained_segment() ;
	create_retained_segment( GRID2 ) ; close_retained_segment() ;
	create_retained_segment( GRID3 ) ; close_retained_segment() ;
	create_retained_segment( GRIDLABEL ) ; close_retained_segment() ;
	create_retained_segment( LABEL ) ; close_retained_segment() ;
	grid_exists = label_exists = 1 ;

	set_image_transformation_type( NONE ) ;
    }
    if ( drawing_exists )
	delete_retained_segment( DRAWING ) ;
    rename_retained_segment( SKETCH, DRAWING ) ;
    drawing_exists = 1 ;
}
