/* ct.c	1.2	(CARL)	8/10/84	12:54:42 */

/*	ct.c	6.1	83/07/29	*/

#include "ct.h"
#if NCT > 0
/*
 * DR11C driver used for CARL Smart Switcher
 */
#include "../machine/pte.h"

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/map.h"
#include "../h/uio.h"
#include "../h/buf.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/kernel.h"

#include "../vaxuba/ubareg.h"
#include "../vaxuba/ubavar.h"
#include "../vaxuba/asw.h"

#define bit(n)	((1) << (n))

#define CT_CSR1		bit(1)

#define	PCAT		(PZERO+9)
#define	CATHIWAT	100
#define	CATLOWAT	30

union ctword {
	short	un_word;
	char	un_bytes[2];
};

struct ct_softc {
	int	sc_openf;
	union	ctword sc_word;
	int	sc_pos;
} ct_softc[NCT];

struct ctdevice {
	short	ctcsr;
	short	ctbuf;
};

int	ctprobe(), ctattach(), ctintr();
struct	uba_device *ctdinfo[NCT];
u_short	ctstd[] = { 0 };
struct	uba_driver ctdriver = { ctprobe, 0, ctattach, 0, ctstd, "ct", ctdinfo };

#define	CTUNIT(dev)	(minor(dev))

ctprobe(reg)
	caddr_t reg;
{
	register int br, cvec;		/* value-result */
	register struct ctdevice *ctaddr = (struct ctdevice *) reg;

#ifdef lint
	br = 0; cvec = br; br = cvec;
	ctintr(0);
#endif
	ctaddr->ctcsr = IENABLE;
	DELAY(10000);
	ctaddr->ctcsr = 0;
	return(sizeof (struct ctdevice));
}

/*ARGSUSED*/
ctattach(ui)
	register struct uba_device *ui;
{
	return(0);
}

ctopen(dev)
	dev_t dev;
{
	register struct ct_softc *sc;
	register struct uba_device *ui;
	register struct ctdevice *ctaddr;

	if (CTUNIT(dev) >= NCT)
		return(ENXIO);
	if ((ui = ctdinfo[CTUNIT(dev)]) == 0)
		return(ENXIO);
	if (ui->ui_alive == 0)
		return(ENXIO);
	if ((sc = &ct_softc[CTUNIT(dev)])->sc_openf)
		return(ENXIO);

	sc->sc_openf = 1;
	sc->sc_pos = 0;
	sc->sc_word.un_word = 0;
	((struct ctdevice *) (ui->ui_addr))->ctcsr = CT_CSR1;

	return (0);
}

ctclose(dev)
	dev_t dev;
{
	ct_softc[CTUNIT(dev)].sc_openf = 0;
}

ctwrite(dev, uio)
	dev_t dev;
	struct uio *uio;
{
	register struct ctdevice *ctaddr;
	register struct ct_softc *sc;
	short word;
	int error;

	sc = &ct_softc[CTUNIT(dev)];
	ctaddr = (struct ctdevice *) ctdinfo[CTUNIT(dev)]->ui_addr;

	while (uio->uio_resid) {
		if ((error = uiomove((caddr_t) &word, sizeof(word), UIO_WRITE, uio)))
			return(error);

		ctaddr->ctbuf = word;
	}

	return(0);
}

ctintr(dev)
	dev_t dev;
{
	printf("ct%d: interrupt\n", CTUNIT(dev));
}

/* ARGSUSED */
ctioctl(dev, cmd, addr, flag)
	dev_t dev;
	caddr_t addr;
{
	register struct uba_device *ui;

	ui = ctdinfo[CTUNIT(dev)];

	switch (cmd) {
		case ASW_RESET:
			((struct ctdevice *) (ui->ui_addr))->ctcsr &= ~CT_CSR1;
			((struct ctdevice *) (ui->ui_addr))->ctcsr |= CT_CSR1;
			break;

		default:
			return(ENOTTY);
			break;
	}

	return(0);
}
#endif
