/* %M%	%I% (CARL) %G%  %U% */

/*
 * these values are critical;
 * dsseq depends on da being 0
 * and ad being 1
 */
# define DA		(0)
# define AD		(1)

/*
 * Errors.
 * Returned in ds_err.errors.
 */
# define EDS_ARGS	01	/* missing arguments/parameters */
# define EDS_ACC	02	/* converters in use */
# define EDS_MOD	04	/* buffer size wasn't modulo MINDSB */
# define EDS_SIZE	010	/* buffer size was too small */
# define EDS_DISK	020	/* disk error */
# define EDS_CERR	040	/* converter error */
# define EDS_RST	0100	/* dsreset clobbered us */

/*
 * Ioctl commands.
 */
# define DSSEQ		((('s') << 8) | 0)	/* set sequence */
# define DSRATE		((('s') << 8) | 1)	/* set rate */
# define DS20KHZ	((('s') << 8) | 2)	/* set 20kHz filter */
# define DS10KHZ	((('s') << 8) | 3)	/* set 10kHz filter */
# define DS5KHZ		((('s') << 8) | 4)	/* set 5kHz filter */
# define DSBYPAS	((('s') << 8) | 5)	/* set bypass filter */
# define DSERRS		((('s') << 8) | 6)	/* get errors */
# define DSBNO		((('s') << 8) | 7)	/* set starting disk block */
# define DSTODO		((('s') << 8) | 8)	/* # of bytes to be done */
# define DSCOUNT	((('s') << 8) | 9)	/* set amnt. to convert */
# define DSBOFF		((('s') << 8) | 10)	/* starting buffer offset */
# define DSNODSK	((('s') << 8) | 11)	/* no disking */
# define DSLAST		((('s') << 8) | 12)	/* last seq ram */
# define DSDEV		((('s') << 8) | 13)	/* disk to use */
# define DSDONE		((('s') << 8) | 14)	/* amnt. done */
# define DSMON		((('s') << 8) | 15)	/* set monitor mode */
# define DSBRD		((('s') << 8) | 16)	/* set broadcast mode */
# define DSNBLKS	((('s') << 8) | 17)	/* # of blocks in block list */
# define DSBLKS		((('s') << 8) | 18)	/* block list */

# define NDSB		2		/* number of buffers chaining with */

# ifdef CARL
/*
 * THIS IS SITE-SPECIFIC
 * CONFIGURED FOR CARL
 * produces 49152 Hz sampling rate when ASCSRT is set to 0x80
 * 4 dacs, 2 adcs, 20KHz and 6.5KHz filters
 */
# define D0BLPT		32		/* number of blocks per CDC track */
# define D1BLPT		51		/* number of blocks per ra81 track */
# define D0MINDSB	(D0BLPT*512)
# define D1MINDSB	(D0BLPT*512)
# define D2MINDSB	(D1BLPT*512)
# define DSCMRCLK	6291456		/* clock frequency */
# define DSCMRTIC	(DSCMRCLK/2)
# define DSCSRATE	49152.0
# define MAXDACS	4
# define MAXADCS	2
# define DSCFLT0	20000.0		/* 20.0KHz */
# define DSCFLT1	6.5		/*  6.5KHz */
# define DSCFLT2	0.0		/* bypass mode */
# define DSCFLT3	0.0		/* not installed */
# define DSHASDAF0	1		/* has flt0 */
# define DSHASDAF1	1		/* has flt1 */
# define DSHASDAF2	1		/* has bypass (everyone does) */
# define DSHASDAF3	0		/* not installed */
# define DSHASADF0	1		/* has flt0 */
# define DSHASADF1	0		/* has flt1 */
# define DSHASADF2	1		/* has bypass */
# define DSHASADF3	0		/* not installed */
# endif CARL

# ifdef IRCAM
/*
 * THIS IS SITE-SPECIFIC
 * CONFIGURED FOR IRCAM
 * produces 48000 Hz sampling rate when ASCSRT is set to 0x80
 * 2 dacs, 2 adcs, 12.8KHz and 6.4KHz filters
 */
# define D0BLPT		31		/* number of blocks per rm80 track */
# define D1BLPT		31		/* additional disks go here */
# define D0MINDSB	(D0BLPT*512)
# define D1MINDSB	(D1BLPT*512)	/* additional disks go here */
# define DSCMRCLK	7680000
# define DSCMRTIC	(DSCMRCLK/2)
# define DSCSRATE	48000.0
# define MAXDACS 	2
# define MAXADCS 	2
# define DSCFLT0	12800.0		/* 12.8KHz */
# define DSCFLT1	 6400.0		/*  6.4KHz */
# define DSCFLT2	    0.0		/* bypass mode */
# define DSCFLT3	    0.0		/* not installed */
# define DSHASDAF0	1		/* has flt0 */
/* NOTE, F1 disabled until fixed */
# define DSHASDAF1	0		/* disabled */
# define DSHASDAF2	1		/* has bypass */
# define DSHASDAF3	0		/* not installed */
# define DSHASADF0	1		/* has flt0 */
/* NOTE, F1 disabled until fixed */
# define DSHASADF1	0		/* disabled */
# define DSHASADF2	1		/* has bypass */
# define DSHASADF3	0		/* not installed */
# endif IRCAM

/*
 * reg specifies a sequence register (0-15).
 * conv specifies a converter.
 * dirt specifies the direction when
 * setting up the sequence ram (DSSEQ) or the
 * sampling rate (DSRATE).
 */
struct ds_seq {
	short reg;
	short conv;
	short dirt;			/* shared by DSSEQ and DSRATE */
};

/*
 * Format of returned converter
 * errors.
 */
struct ds_err {
	short dma_csr;
	short asc_csr;
	short errors;
};

/*
 * File information.
 * The member bnosiz is used for
 * lots of things; starting block number
 * of the file, size of the file, amount
 * to convert, etc.
 * On the vax this structure
 * is the wrong size; 8 bytes instead
 * of the desired 6; fs_unused isn't
 * used so this shouldn't be a problem.
 */
struct ds_fs {
	daddr_t bnosiz;
	short fs_unused;
};
