/* lock driver for sound file system */

# include "lk.h"
#if NLK > 0

#include "../h/param.h"
#include "../h/systm.h"
#include "../h/tty.h"
#include "../h/pte.h"
#include "../h/map.h"
#include "../h/buf.h"
#include "../h/ubareg.h"
#include "../h/ubavar.h"
#include "../h/conf.h"
#include "../h/dir.h"
#include "../h/user.h"

struct lk_softc {
	int		lk_flags;	/* flags */
} lk_softc[NLK];

lkopen(dev)
	dev_t dev;
{
	register struct lk_softc *sc;
	register int unit;

	unit = minor(dev);
	sc = &lk_softc[0];

	if (sc->lk_flags & (1 << unit)) {
		u.u_error = EBUSY;
		return;
	}

	sc->lk_flags |= 1 << unit;
}

lkclose(dev)
	dev_t dev;
{
	register struct lk_softc *sc = &lk_softc[0];

	sc->lk_flags &= ~(1 << minor(dev));
}
