h34846
s 00501/00000/00000
d D 1.1 88/03/16 16:49:17 root 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

/*
 * The "-c" flag will sequence through multiple plots and stop on the last
 * one, the "-C" flag will do the same but automatically skip back to the
 * beginning and continue sequencing when it reaches the end ("demo"
 * mode).  Middle button goes to next plot (if there is one), right button
 * restarts plot from beginning (file may have been overwritten in the
 * meantime).  The left button quits.
 */

/*
 * sunplot converts graph (device independent plot) output into SUNcore graphics
 * compile with:

     cc -fsingle -O sunplot.c -lcore -lsunwindow -lpixrect -lm -o sunplot

 * this program has been known to work on SUN-2s and SUN-3s, with or without
 * hardware floating point accellerators
 * on SUN-2s, "core" may be "coresky" if the "-fsky" flag is used with cc
 * on SUN-3s, be sure to use the "-f68881" compile flag as appropriate
 * in any case, the "-fsingle" flag should be used
 * if it is to be run on both Sun-2 and Sun-3 machines, compile it on the
 * former for code compatability
 * author: F. R. Moore (ucbvax!sdcarl!frm) Oct 87
 * last revisions:	Nov 87 (frm)
 * 			Mar 88 (frm)
 */
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <usercore.h>
#include <signal.h>

int bw2dd() ;
struct vwsurf rawsurface = DEFAULT_VWSURF( bw2dd ) ;
int pixwindd() ;
struct vwsurf windowsurface = DEFAULT_VWSURF( pixwindd ) ;
struct vwsurf *surface ;

double TWOPI ;
/*
 * method for reading bytes from stdin
 */
#define GET4b b1 = fgetc(fp) ; b2 = fgetc(fp) ; b3 = fgetc(fp) ; b4 = fgetc(fp)
#define GET2b b1 = fgetc(fp) ; b2 = fgetc(fp)
/* 
 * method for combining byte-pairs into signed 16-bit (short) coordinate values
 */
#define COORD( a, b ) (( b << 8 ) | a )
/*
 * minimum number of sides for a small circle or arc
 */
#define NMIN 16
/*
 * maximum number of sides for a large circle or arc
 */
#define NMAX 360

int button ;
FILE *fp ;
char fname[BUFSIZ] ;

main( argc, argv ) int argc ; char * argv[] ; {
 char c, lastc, textstring[BUFSIZ] ;
 int i, b1, b2, b3, b4, cnt, sleeptime = 5, autores = 0 ;
 short x0, y0, x1, y1, x2, y2 ;
 float x, y, r, umin = 0., umax = 1., vmin = 0., vmax = 0.75, bx, by ;
 float ndcx = 1., ndcy = 0.75 ;            /* default ndc space */
 int prevplot = 0, debug = 0, cont = 0 ;
    TWOPI = 8.*atan( 1. ) ;
/*
 * if no arguments, describe program usage
 */
    if ( argc == 1 && isatty(0) ) {
	printf( 
"%s%s%s%s%s%s%s%s",
"SUNPLOT Usage: sunplot [flags] [filename]\n",
" reads input from file (or stdin if no filename given)\n",
" input must be UNIX plot commands (e.g., graph output)\n",
" FLAGS:\n",
" `-c N'     - autocontinue with N seconds between successive plots [N=5]\n",
" `-C N'     - autocontinue AND autorestart, N seconds between plots [N=5]\n",
" `-ndc x y' - set ndc space (aspect ratio) to (x,y) [(1,.75)]\n",
" `-D'       - print debug output\n"
) ;
	exit( 0 ) ;
    }
/*
 * sunplot will execute a restart (button 3) on receipt of signal 30
 * write executable ".biffplot" file containing restart signaler
 */
    if ( ( fp = fopen( ".biffplot", "w" ) ) == NULL )
	fprintf( stderr, "sunplot: can't create .biffplot\n" ) ;
    else {
	fprintf( fp, "kill -30 %d\n", getpid() ) ;
	fclose( fp ) ;
	chmod( ".biffplot", 0755 ) ;
    }
    fp = stdin ;
/*
 * check for recognized flags
 */
    if ( argc > 1 ) {
	for ( i = 1 ; i < argc ; i++ ) {
	    if ( !strcmp( argv[i], "-c" ) ) {
		cont = 1 ;
		if ( i+1 < argc && isdigit( *argv[i+1] ) ) {
		    sleeptime = atoi( argv[i+1] ) ;
		    i += 1 ;
		}
	    } else if ( !strcmp( argv[i], "-C" ) ) {
		autores = cont = 1 ;
		if ( i+1 < argc && isdigit( *argv[i+1] ) ) {
		    sleeptime = atoi( argv[i+1] ) ;
		    i += 1 ;
		}
	    } else if ( !strcmp( argv[i], "-D" ) )
		debug = 1 ;
	    else if ( !strcmp( argv[i], "-ndc" ) ) {
		if ( i+1 < argc && 
		    ( isdigit( *argv[i+1] ) || *argv[i+1] == '.' )
		) {
		    ndcx = atof( argv[i+1] ) ;
		    i += 1 ;
		}
		if ( i+1 < argc && 
		    ( isdigit( *argv[i+1] ) || *argv[i+1] == '.' )
		) {
		    ndcy = atof( argv[i+1] ) ;
		    i += 1 ;
		}
	    } else {
		strcpy( fname, argv[i] ) ;
		if ( ( fp = fopen( fname, "r" ) ) == NULL ) {
		    fprintf(stderr, "sunplot: can't open file '%s'\n", fname ) ;
		    exit( -1 ) ;
		}
	    }
	}
    }
/*
 * unless debugging, initialize SUNcore and open a drawing (segment)
 */
    if ( !debug )
	setup_core( ndcx, ndcy ) ;
/*
 * main loop--come here on restart
 */
start:

    prevplot = 0 ;
    lastc = 'e' ;
    if ( !debug ) {
	delete_all_retained_segments() ;
	create_retained_segment( 1 ) ;
    }
/*
 * fetch bytes from stdin (see "man 5 plot" for format details)
 */
    while ( ( c = fgetc(fp) ) != EOF ) {
	switch ( c ) {
/*
 * erase plot--if "-c" or "-C" flag given, pause briefly between successive
 * plots, otherwise wait for buttons after each successive plot
 */
	case 'e':
	    if ( debug ) {
		printf( "e\n" ) ;
		break ;
	    }
	    if ( !prevplot )
		break ;
	    if ( cont ) {
		sleep( sleeptime ) ;
		delete_all_retained_segments() ;
		create_retained_segment( 1 ) ;
		lastc = 'e' ;
		break ;
	    }
	    if ( autores )
		button = 3 ;
	    else {
		map_ndc_to_world_2( 0.125, 0.01, &x, &y ) ;
		move_abs_2( x, y ) ;
		text( "--More-- Buttons: quit, continue, restart" ) ;
		for ( button = 0 ; button == 0 ; )
		    await_any_button_get_locator_2(
			100000, 1, &button, &bx, &by ) ;
	    }
	    delete_all_retained_segments() ;
	    create_retained_segment( 1 ) ;
	    if ( button == 1 ) {
		delete_all_retained_segments() ;
		setdown_core() ;
		exit( 0 ) ;
	    }
	    if ( button == 3 ) {
		fclose( fp ) ;
		if ( ( fp = fopen( fname, "r" ) ) == NULL ) {
		    fprintf(stderr, "sunplot: can't reopen file '%s'\n",
			fname ) ;
		    exit( -1 ) ;
		}
		goto start ;
	    }
	    lastc = 'e' ;
	    break ;
/*
 * set coordinate limits for drawing
 */
	case 's':
	    GET4b ; x0 = COORD( b1, b2 ) ; y0 = COORD( b3, b4 ) ;
	    GET4b ; x1 = COORD( b1, b2 ) ; y1 = COORD( b3, b4 ) ;
	    if ( debug ) {
		printf( "s %d %d %d %d\n", x0, y0, x1, y1 ) ;
		break ;
	    }
	    umin = x0 ; umax = x1 ; vmin = y0 ; vmax = y1 ;
	    vmin -= 0.05*( vmax - vmin ) ;
	    set_window( umin, umax, vmin, vmax ) ;
	    set_charsize(
		(ndcy/.75)*(umax - umin)/80.,
		ndcx*(vmax - vmin)/60.
	    ) ;
	    if ( lastc == 'e' ) {
		delete_all_retained_segments() ;
		create_retained_segment( 1 ) ;
	    }
	    lastc = 's' ;
	    break ;
/*
 * move to new current position
 */
	case 'm':
	    GET4b ; x0 = COORD( b1, b2 ) ; y0 = COORD( b3, b4 ) ;
	    if ( debug ) {
		printf( "m %d %d\n", x0, y0 ) ;
		break ;
	    }
	    x = x0 ; y = y0 ;
	    move_abs_2( x, y ) ;
	    lastc = 'm' ;
	    prevplot = 1 ;
	    break ;
/*
 * draw line from current to new position
 */
	case 'n':
	    GET4b ; x0 = COORD( b1, b2 ) ; y0 = COORD( b3, b4 ) ;
	    if ( debug ) {
		printf( "n %d %d\n", x0, y0 ) ;
		break ;
	    }
	    x = x0 ; y = y0 ;
	    line_abs_2( x, y ) ;
	    lastc = 'n' ;
	    prevplot = 1 ;
	    break ;
/*
 * place point at given position
 */
	case 'p':
	    GET4b ; x0 = COORD( b1, b2 ) ; y0 = COORD( b3, b4 ) ;
	    if ( debug ) {
		printf( "p %d %d\n", x0, y0 ) ;
		break ;
	    }
	    x = x0 ; y = y0 ;
	    move_abs_2( x, y ) ;
	    line_abs_2( x, y ) ;
	    lastc = 'p' ;
	    prevplot = 1 ;
	    break ;
/*
 * draw line between given endpoints
 */
	case 'l':
	    GET4b ; x0 = COORD( b1, b2 ) ; y0 = COORD( b3, b4 ) ;
	    GET4b ; x1 = COORD( b1, b2 ) ; y1 = COORD( b3, b4 ) ;
	    if ( debug ) {
		printf( "l %d %d %d %d\n", x0, y0, x1, y1 ) ;
		break ;
	    }
	    x = x0 ; y = y0 ;
	    move_abs_2( x, y ) ;
	    x = x1 ; y = y1 ;
	    line_abs_2( x, y ) ;
	    lastc = 'l' ;
	    prevplot = 1 ;
	    break ;
/*
 * draw text string beginning at current position
 * (move current position to end of string)
 */
	case 't':
	    for ( cnt = 0 ; ( c = fgetc(fp) ) != '\n' ; cnt++ )
		textstring[cnt] = c ;
	    textstring[cnt] = '\0' ;
	    if ( debug ) {
		printf( "t " ) ;
		printf( "'%s'\n", textstring ) ;
		break ;
	    }
	    text( textstring ) ;
	    inquire_text_extent_2( textstring, &x, &y ) ;
	    move_rel_2( x, y ) ;
	    lastc = 't' ;
	    prevplot = 1 ;
	    break ;
/*
 * draw arc given center, starting and ending points (polar method used)
 */
	case 'a':
	    GET4b ; x0 = COORD( b1, b2 ) ; y0 = COORD( b3, b4 ) ;
	    GET4b ; x1 = COORD( b1, b2 ) ; y1 = COORD( b3, b4 ) ;
	    GET4b ; x2 = COORD( b1, b2 ) ; y2 = COORD( b3, b4 ) ;
	    if ( debug ) {
		printf( "a %d %d %d %d %d %d\n", x0, y0, x1, y1, x2, y2 ) ;
		break ;
	    }
	    {
	     float size, *xlist, *ylist ;
	     double fac, a1, a2, da ;
	     int i, N ;
		x = x1 - x0 ;
		y = y1 - y0 ;
		r = sqrt( (double) ( x*x + y*y ) ) ;
		size = umax - umin ;
		if ( vmax - vmin > size )
		    size = vmax - vmin ;
		size = r/size ;
		N = NMIN + size*(NMAX - NMIN) ;
		if ( N > NMAX )
		    N = NMAX ;
		a1 = atan2( (double) (y1 - y0), (double) (x1 - x0) ) ;
		a2 = atan2( (double) (y2 - y0), (double) (x2 - x0) ) ;
		if ( a1 > a2 )
		    a2 += TWOPI ;
		da = a2 - a1 ;
		if ( da == 0. )
		    da = TWOPI ;
		N *= da/TWOPI ;
		if ( N < NMIN )
		    N = NMIN ;
		fac = da/(N-1) ;
		xlist = (float *) malloc( N*sizeof(float) ) ;
		ylist = (float *) malloc( N*sizeof(float) ) ;
		x = x0 ;
		y = y0 ;
		for ( i = 0 ; i < N ; i++ ) {
		    xlist[i] = x + r*cos( a1 + fac*i ) ;
		    ylist[i] = y + r*sin( a1 + fac*i ) ;
		}
		move_abs_2( xlist[0], ylist[0] ) ;
		polyline_abs_2( xlist, ylist, N ) ;
		free( xlist ) ;
		free( ylist ) ;
	    }
	    lastc = 'a' ;
	    prevplot = 1 ;
	    break ;
/*
 * draw circle given center and radius (polar method used)
 */
	case 'c':
	    GET4b ; x0 = COORD( b1, b2 ) ; y0 = COORD( b3, b4 ) ;
	    GET2b ; x1 = COORD( b1, b2 ) ;
	    if ( debug ) {
		printf( "c %d %d %d\n", x0, y0, x1 ) ;
		break ;
	    }
	    {
	     float size, *xlist, *ylist ;
	     double fac ;
	     int i, N ;
		x = x0 ;
		y = y0 ;
		r = x1 ;
		size = umax - umin ;
		if ( vmax - vmin > size )
		    size = vmax - vmin ;
		size = r/size ;
		N = NMIN + size*(NMAX - NMIN) ;
		if ( N > NMAX )
		    N = NMAX ;
		fac = TWOPI/(N-1) ;
		xlist = (float *) malloc( N*sizeof(float) ) ;
		ylist = (float *) malloc( N*sizeof(float) ) ;
		for ( i = 0 ; i < N ; i++ ) {
		    xlist[i] = x + r*cos( fac*i ) ;
		    ylist[i] = y + r*sin( fac*i ) ;
		}
		move_abs_2( xlist[0], ylist[0] ) ;
		polyline_abs_2( xlist, ylist, N ) ;
		free( xlist ) ;
		free( ylist ) ;
	    }
	    lastc = 'c' ;
	    prevplot = 1 ;
	    break ;
/*
 * set line drawing style to various supported options
 */
	case 'f':
	    for ( cnt = 0 ; ( c = fgetc(fp) ) != '\n' ; cnt++ )
		textstring[cnt] = c ;
	    textstring[cnt] = '\0' ;
	    if ( debug ) {
		printf( "f\n" ) ;
		break ;
	    }
	    if ( !strcmp( textstring, "solid" ) )
		set_linestyle( SOLID ) ;
	    else if ( !strcmp( textstring, "longdashed" ) )
		set_linestyle( DASHED ) ;
	    else if ( !strcmp( textstring, "dotted" ) )
		set_linestyle( DOTTED ) ;
	    else if ( !strcmp( textstring, "shortdashed" ) )
		set_linestyle( DASHED ) ;
	    else if ( !strcmp( textstring, "dotdashed" ) )
		set_linestyle( DOTDASHED ) ;
	    else
		set_linestyle( SOLID ) ;
	    lastc = 'f' ;
	    break ;
	default:
	    if ( debug ) {
		printf( "unrecognized plot command\n" ) ;
	    }
	    break ;
	}
    }
/*
 * wait for buttons after last drawing (unless autorestart mode specified)
 */
    if ( !debug ) {
	if ( autores ) {
	    sleep( sleeptime ) ;
	    button = 3 ;
	} else {
	    map_ndc_to_world_2( 0.125, 0.01, &x, &y ) ;
	    move_abs_2( x, y ) ;
	    text( "Buttons: quit, nop, restart" ) ;
	    for ( button = 0 ; button == 0 || button == 2 ; )
		await_any_button_get_locator_2( 100000, 1, &button, &bx, &by ) ;
	}
	if ( button == 3 ) {
	    fclose( fp ) ;
	    if ( ( fp = fopen( fname, "r" ) ) == NULL ) {
		fprintf(stderr, "sunplot: can't open file '%s'\n", fname ) ;
		exit( -1 ) ;
	    }
	    goto start ;
	}
	setdown_core() ;
    }
}
setup_core( ndcx, ndcy ) float ndcx, ndcy ; {
 int _core_winsig(), catchit() ;
    if ( getenv( "WINDOW_ME" ) )
	surface = &windowsurface ;
    else
	surface = &rawsurface ;
    if ( initialize_core( DYNAMICA, SYNCHRONOUS, TWOD ) )
	exit( 1 ) ;
    if( get_view_surface( surface, NULL ) )
	exit( 2 ) ;
    if ( initialize_view_surface( surface, FALSE ) )
	exit( 3 ) ;
    if ( select_view_surface( surface ) )
	exit( 4 ) ;
    set_ndc_space_2( ndcx, ndcy ) ;        /* optional adjustment */
    set_viewport_2( 0., ndcx, 0., ndcy ) ; /* optional adjustment */
    set_charprecision( CHARACTER ) ;
    set_font( STICK ) ;
    initialize_device( BUTTON, 1) ;
    initialize_device( BUTTON, 2) ;
    initialize_device( BUTTON, 3) ;
    initialize_device( LOCATOR, 1);
    initialize_device( KEYBOARD, 1);
    set_echo( LOCATOR, 1, 1 ) ;
    set_echo_position( LOCATOR, 1, 0., 0. ) ;
    set_echo_surface( LOCATOR, 1, surface ) ;
    set_charsize( ndcy/80., ndcx/80. ) ;
    signal( 30, catchit ) ;
    signal( SIGWINCH, _core_winsig ) ;
}
setdown_core() {
    delete_all_retained_segments() ;
    terminate_device( BUTTON, 1 ) ;
    terminate_device( BUTTON, 2 ) ;
    terminate_device( BUTTON, 3 ) ;
    terminate_device( LOCATOR, 1);
    terminate_device( KEYBOARD, 1);
    deselect_view_surface( surface ) ;
    terminate_core() ;
}
catchit() {	/* simulate a button 3 push */
    button = 3 ;
}
E 1
