h13531
s 00018/00041/00027
d D 1.2 88/03/16 17:01:21 root 2 1
c New improved (working!) version.
e
s 00068/00000/00000
d D 1.1 88/03/16 16:46:55 root 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/carl.h>

/*
D 2
 * vax2sun - convert sun single precision floating point to vax spf
 * NOTE: this runs only on a VAX.
 * How it works:
 * Between a vax and a sun, there is a high-bite/low-bite swap for each short.
 * However, by a combination of artifacts of getfloat(), the unscrambling
 * is done for us.
 * Vaxes do not use IEEE floating point, suns do.  
 * The vax uses excess 128 representation for the exponent, whereas
 * the sun seems to use excess 126, necessitating an add by 2.
 * So, we split each 4 bytes
 * into the components: sign bit, exponent and mantissa.  For both a vax and
 * a sun, these are fortunately the same size and position:
 * SEEEEEEEEMMMMMMMMMMMMMMMMMMMMMMM
 * then do the add, then recombine elements.  The value for 0.0 is
 * non-uniform and must be treated specially.  It is 0:<31,0> on a vax, and
 * 1:<31>,0:<30,0> on a sun.
 * One additional artifact is that we must swap the shorts of the reassembled
 * vax float in order to get them in the right order out of putfloat().
 * Bugs: The add by 2 should check that the value does not overflow 255.
E 2
I 2
 * sun2vax must be compiled and executed on a VAX
 * converts Sun (IEEE) binary float to vax format
E 2
 */

I 2
extern int fgetlong();
#define getlong(fptr)fgetlong(fptr,stdin)

E 2
main(argc, argv)
	char **argv;
{
	register char x[4];
D 2
	unsigned long vax_zero = 0;
E 2
I 2
	register char y[4];
E 2

	if (isatty(1) || argc > 1)
		usage(1);

D 2
	while (getfloat((float *) x) > 0) {
		unsigned long f;
		register char S = (x[0] & 0x80);	/* pick off sign bit */
		register char exp = (x[0] << 1) | ((x[1] >> 7) & 1);
		register long mant = ((x[1] & 0x7F) << 16) 
			| ((x[2] & 0xFF) << 8) | (x[3] & 0xFF);
E 2
I 2
	while (getlong((long*)x) > 0) {
		y[1] = x[0];
		y[0] = x[1];
		y[3] = x[2];
		y[2] = x[3];
		if (y[1] != 0)
			y[1] += 1;
E 2

D 2
		if (S != 0 && exp == 0 && mant == 0) {	/* sun 0.0 ? */
			putfloat(&vax_zero);	/* substitute vax 0.0 */
			continue;
		}
		exp += 2;
		f = (exp << 23);
		f |= (mant & 0xFFFFFF);
		if (S == 0)
			f &= 0x7FFFFFFF;	/* turn off sign bit */
		else
			f |= 0x80000000;	/* turn on sign bit */
		f = (f << 16) | ((f >> 16) & 0xFFFF);	/* swap shorts */
		putfloat(&f);
E 2
I 2
		putfloat((float*)y);
E 2
	}
	flushfloat();
	exit(0);
}

usage(ex)
{
D 2
	fprintf(stderr, "%s%s",
E 2
I 2
	fprintf(stderr, "%s%s%s",
E 2
		"usage: sun2vax < sun_floatsams > vax_floatsams\n",
D 2
		"output must be a file or pipe\n");
E 2
I 2
		"output must be a file or pipe\n",
		"runs only on a sun\n"
		);
E 2
	exit(ex);
}
E 1
