# include <stdio.h>
# include <carl/paths.h>
# include "sfstab.h"

# define	STRLEN	40

static FILE		*fid;
static int		line;
static char		*stname;
static struct sfstab	*st;

endsfstab() {
	if (fid != NULL) {
		fclose(fid);
		fid = NULL;
		stfree(st);
		st = NULL;
	}
}

setsfstab() {
	extern struct sfstab	*stalloc();

	stname = libdir(sfstab);

	if (fid == NULL) {
		if ((fid = fopen(stname, "r")) == NULL) {
			fprintf(stderr, "fopen: ");
			perror(stname);
			return(NULL);
		}
		line = 1;
	}
	else {
		rewind(fid);
		line = 1;
	}

	if (st == NULL) {
		if ((st = stalloc(1)) == NULL)
			return(NULL);
	}
}

struct sfstab *
getsfstabnam(name)
	char			*name;
{
	extern struct sfstab	*getsfstabent();
	register struct sfstab	*st;

	while ((st = getsfstabent()) != NULL) {
		if (strcmp(name, st->st_dir) == 0) {
			endsfstab();
			return(st);
		}
	}

	return(NULL);
}

struct sfstab *
getsfstabent() {
	char			buf[BUFSIZ];
	int			n;

	if ((fid == NULL) || (st == NULL)) {
		setsfstab();
		if ((fid == NULL) || (st == NULL))
			return(NULL);
	}

	if (fgets(buf, sizeof(buf), fid) == NULL)
		return(NULL);

	if ((n = sscanf(buf, "%[^:]:%[^:]:%[^:]:%d:%d:%d:%[^:]:%d:",
	    st->st_dir, st->st_dev, st->st_mode,
	    &st->st_cylsize, &st->st_olock, &st->st_tracksize,
	    st->st_lock, &st->st_disksize)) != 8)
		fprintf(stderr, "getsfstab: %s: line %d bad (%d)\n",
		    stname, line, n);

	line++;

	return(st);
}

struct sfstab *
stalloc(n) {
	extern char		*calloc();
	register struct sfstab	*st;

	if ((st = (struct sfstab *) calloc(1, sizeof(struct sfstab))) == NULL)
		return(NULL);

	if ((st->st_dir = calloc(1, STRLEN)) == NULL) {
		stfree(st);
		return(NULL);
	}
	if ((st->st_dev = calloc(1, STRLEN)) == NULL) {
		stfree(st);
		return(NULL);
	}
	if ((st->st_mode = calloc(1, STRLEN)) == NULL) {
		stfree(st);
		return(NULL);
	}
	if ((st->st_lock = calloc(1, STRLEN)) == NULL) {
		stfree(st);
		return(NULL);
	}

	return(st);
}

stfree(st)
	register struct sfstab	*st;
{
	if (st->st_dir != NULL)
		free(st->st_dir);
	if (st->st_dev != NULL)
		free(st->st_dev);
	if (st->st_mode != NULL)
		free(st->st_mode);
	if (st->st_lock != NULL)
		free(st->st_lock);

	free((char *) st);
}
