# include <ctype.h>
# include <stdio.h>

struct comps {
	char	*co_name;		/* name of company	*/
	float	co_paid;		/* total $ spent there	*/
	float	co_hippg;		/* highest price paid	*/
	float	co_loppg;		/* lowest price paid	*/
	float	co_gals;		/* number of gallons	*/
	int	co_count;		/* number of visits	*/
	struct	comps *co_nextcp;	/* pointer to next	*/
};

struct comps cohead;

float	totgal;
float	totpaid;
float	odo;
float	odo1;
float	gal1;

int	line = 0;

int	vflag = 0;
int	tflag = 0;

main(argc, argv)
	char **argv;
{
	register FILE *fd;
	register char *pv;
	register int i, j;
	int num;

	for (i = 1; i < argc; i++) {
		pv = argv[i];
		if (pv[0] != '-')
			break;
		for (j = 1; pv[j] != NULL; j++) {
			switch (pv[j]) {
				case 'v':
					vflag = 1;
					break;

				case 't':
					tflag = 1;
					break;

				default:
					fprintf(stderr, "mpg: usage: mpg [-v] [-t] [file]\n");
					exit(1);
					break;
			}
		}
	}

	if (i == argc)
		fd = stdin;
	else {
		if ((fd = fopen(argv[i], "r")) == NULL) {
			perror(argv[i]);
			exit(1);
		}
	}

	getlines(fd);
	printmpg();
}

getlines(fd)
	register FILE *fd;
{
	register struct comps *cp;
	float	gal;
	float	cost;
	char	buf[BUFSIZ];
	char	name[40];
	char	junk[40];
	int	flds;

	odo1 = 0.0;
	gal1 = 0.0;

	totgal = 0.0;
	totpaid = 0.0;

	while (fgets(buf, BUFSIZ, fd) != NULL) {
		line++;

		if (iscmt(buf))
			continue;

		odo = 0.0;
		cost = 0.0;

		name[0] = NULL;

		/* odo gal cost company date invoice */
		flds = sscanf(buf, "%f%f%f%s%s%s",
			&odo,
			&gal,
			&cost,
			&name[0],
			&junk[0],
			&junk[0]);

		if (flds < 3)
			fmterr();

		/*
		 * skip the first gas because
		 * it inflates the actual gas
		 * usage.
		 */
		if (odo1 == 0.0) {
			odo1 = odo;
			gal1 = gal;
		}

		totgal += gal;

		totpaid += cost;

		if (vflag)
			cosum(&name[0], cost, gal);

		if (tflag && (odo != odo1))
			printf("%.1f: mpg=%.2f $pm=$%.2f\n",
				odo,
				(odo - odo1) / (totgal - gal1),
				100 * (totpaid / (odo - odo1))
				);
	}

}

cosum(name, cost, gal)
	char	*name;
	float	cost, gal;
{
	extern struct comps *cpalloc();
	extern char *xalloc();
	register struct comps *lastcp;
	register struct comps *cp;
	float ppg;

	ppg = cost / gal;

	mklower(name);

	/*
	 * check and see if we have an entry for this
	 * gas station on the list. slow linear search.
	 */
	lastcp = &cohead;
	for (cp = cohead.co_nextcp; cp != NULL; cp = cp->co_nextcp) {
		if (strcmp(name, cp->co_name) == 0) {
			cp->co_gals += gal;

			cp->co_paid += cost;

			if (ppg > cp->co_hippg)
				cp->co_hippg = ppg;
			if (ppg < cp->co_loppg)
				cp->co_loppg = ppg;

			cp->co_count++;

			return;
		}

		lastcp = cp;
	}

	/*
	 * not on the list, add it
	 */
	cp = cpalloc(1);
	cp->co_nextcp = NULL;
	cp->co_name = xalloc(strlen(name) + 1);
	strcpy(cp->co_name, name);
		cp->co_gals = gal;
	cp->co_paid = cost;
	cp->co_hippg = ppg;
	cp->co_loppg = ppg;

	cp->co_count = 1;

	lastcp->co_nextcp = cp;
}

printmpg() {
	register struct comps *cp;

	if (vflag) {
		printf("%s\t%s\t%s\t%s\t%s\t%s\n",
			"Company", "Paid", "High", "Low", "Avg", "Cnt");

		for (cp = cohead.co_nextcp; cp != NULL; cp = cp->co_nextcp) {
			if (islower(cp->co_name[0]))
				cp->co_name[0] = toupper(cp->co_name[0]);

			printf("%s\t$%.2f\t%.2f\t%.2f\t%.2f\t%d\n",
				cp->co_name,
				cp->co_paid,
				cp->co_hippg,
				cp->co_loppg,
				cp->co_paid/cp->co_gals,
				cp->co_count);
		}

		printf("\n");
	}

	printf("%s\t%s\t%s\t%s\t%s\n",
		"Miles", "Gallons", "Dollars", "MPG", "$ Per 100 Miles");
	printf("%.1f\t%.2f\t$%.2f\t%.2f\t$%.2f\n",
		(odo - odo1),
		totgal,
		totpaid,
		(odo - odo1) / (totgal - gal1),
		100 * (totpaid / (odo - odo1))
		);
}

struct comps *
cpalloc(n) {
	extern char *calloc();
	register struct comps *cp;

	if ((cp = (struct comps *) calloc(n, sizeof(struct comps))) == NULL) {
		perror("calloc");
		exit(1);
	}

	return(cp);
}

char *
xalloc(n) {
	extern char *calloc();
	register char *cp;

	if ((cp = calloc(1, n)) == NULL) {
		perror("calloc");
		exit(1);
	}

	return(cp);
}

iscmt(cp)
	char	*cp;
{
	while (isspace(*cp))
		cp++;

	if (*cp == '#')
		return(1);

	return(0);
}

mklower(str)
	char *str;
{
	register char *cp;

	for (cp = str; *cp != NULL; cp++) {
		if (isupper(*cp))
			*cp = tolower(*cp);
	}
}

fmterr() {
	fprintf(stderr, "input file in incorrect format (line %d)\n", line);
	exit(1);
}
