/* wr.c	1.3	(CARL)	8/16/82	18:15:29 */

static char SID_wr[] = "@(#)wr.c 1.3 (CARL) 8/16/82";

# include <sysexits.h>
# include <signal.h>
# include <ctype.h>
# include <stdio.h>
# include "catt.h"

static char *hlp[] = {
	"%c.                disconnect.",
	"%cCX               change command char to \"X\".",
	"%c?                print a summary of the available commands.",
	"%c!cmd             run \"cmd\" on local system.",
	"%c$cmd             run \"cmd\" on local system, send output to remote.",
	"%c<file            transmit contents of \"file\" to remote.",
	"%c>file            collect output from remote into \"file\".",
	"%c%%take from [to]  copy file \"from\" on remote to \"to\" on local.",
	"%c%%put from [to]   copy file \"from\" on local to \"to\" on remote.",
	"%c%%cd dir          change directory on local.",
	"%c%%speed baud      change line speed.",
	NULL,
};

extern int wrsig2();
static char wrtmpbuf[BUFSIZ];
static char cmdch;
static bool wrintr;

/*
 * wr: write to remote: 0 -> line.
 * commands:
 *
 *	~.      terminate
 *	~<file  send file
 *	~!      local login-style shell
 *	~!cmd   execute cmd locally
 *	~$cmd   execute cmd locally, send output to line
 *	~%cmd   execute builtin cmd (put and take)
 */
wr() {
	register char *bp;
	char *buf;
	char ch;
	bool mslash;
	bool cpy;
	bool map;
	bool nl;

	buf = alloc(BUFSIZ);
	cmdch = '~';

	cpy = FALSE;
	map = FALSE;
	nl = TRUE;

	while (read(0, &ch, CHRSIZ) == CHRSIZ) {
		ch &= 0177;

		/*
		 * map input upper case to lower case,
		 * map chars preceded by a backslash.
		 * this hasn't been used in a long time,
		 * dunno if it still works.
		 */
		if (lcase) {
			mslash = FALSE;
			if (isalpha(ch) && isupper(ch)) {
				ch = tolower(ch);
				mslash = FALSE;
			}
			if (map) {
				if (isprint(ch)) {
					ch = maptab[ch];
					if (mslash = (ch == '\\'))
						map = FALSE;
				}
			}
			if (mslash == FALSE)
				if (map = (ch == '\\'))
					continue;
		}

		/*
		 * start copying the line if
		 * the first char is the command
		 * character.
		 */
		if (ch == cmdch) {
			if (nl) {
				cpy = TRUE;
				bp = &buf[0];
			}
			else if ((bp == &buf[1]) && cpy)
				cpy = FALSE;
		}

		/*
		 * check for end of line,
		 * run the command if we were
		 * collecting the line for one.
		 */
		if (nl = ((ch == '\n') || (ch == '\r'))) {
			if (cpy) {
				cpy = FALSE;
				*bp = NULL;
				if (docmd(&buf[1]))
					return;
				continue;
			}
		}

		/*
		 * convert breaks to dels.
		 */
		if (ch == 0)
			ch = 0177;

		/*
		 * copy characters into the
		 * command buffer. handle back-
		 * spacing and line killing.
		 * make sure we don't overrun the
		 * buffer.
		 */
		if (cpy) {
			putc(ch, stdout);
			if (ch == terase) {
				*bp-- = NULL;
				if (bp < &buf[0]) {
					cpy = FALSE;
					nl = TRUE;
				}
			}
			else if ((ch == tkill) || (ch == tintr)) {
				echo(crlf);
				cpy = FALSE;
				nl = TRUE;
			}
			else
				*bp++ = ch;

			if (bp >= &buf[BUFSIZ])
				bp--;

			continue;
		}

		if (write(ln, (char *) &ch, CHRSIZ) != CHRSIZ)
			diag("write error: %s", sys_errlist[errno]);
	}
}

docmd(buf)
char *buf;
{
	file *fid;
	int ch;
	int tmpspd;
	bool err;
	auto nulls;

	echo(crlf);
	switch (buf[0]) {
		case 'b':
			if (buf[1] != NULL)
				nulls = atoi(&buf[1]);
			else
				nulls = 6;
			sendbrk(nulls);
			break;

		case 'C':
			if ((buf[1] == NULL) || (buf[2] != NULL)) {
				diag("must be one char for command char.");
				break;
			}
			cmdch = buf[1];
			break;

		case 'h':
			hflg = TRUE;
			tty(T_RAW);
			break;

		case 'v':
			diag(version);
			break;

		case 's':
			tmpspd = atoi(buf+1);
			if (spdchk(tmpspd, TRUE) == ERR) {
				diag("invalid speed: %s", buf+1);
				break;
			}
			line(L_SPEED);
			break;

# ifdef SIGTSTP
		case 'z':
			tty(T_NORM);
			if (kill(rdpid, SIGTSTP) == -1)
				diag("kill error: %s", sys_errlist[errno]);
			if (kill(getpid(), SIGTSTP) == -1)
				diag("kill error: %s", sys_errlist[errno]);
			/* stops/continues here */
			if (kill(rdpid, SIGCONT) == -1) {
				diag("kill error: %s", sys_errlist[errno]);
				return(ERR);
			}
			tty(T_RAW);
			break;
# endif SIGTSTP

		case '?':
			help();
			break;

		case '.':
			return(ERR);

		case '!':
		case '$':
			pump(buf);
			break;

		case '<':
			if (buf[1] == NULL) {
				diag("no input file?");
				break;
			}
			if ((fid = fopen(&buf[1], "r")) == NULL) {
				diag("fopen error: %s: %s", buf+1, sys_errlist[errno]); 
				break;
			}
			wrintr = FALSE;
			err = FALSE;
			tty(T_SLNT);
			if (nhup == SIG_DFL)
				(void) signal(SIGINT, wrsig2);
			while ((ch = getc(fid)) != EOF) {
				if (wrintr)
					break;
				if (write(ln, (char *) &ch, CHRSIZ) != CHRSIZ) {
					diag("write error: %s", sys_errlist[errno]);
					err = TRUE; 
					break;
				}
			}
			(void) signal(SIGINT, SIG_IGN);
			fclose(fid);
			tty(T_RAW);
			if (err)
				return(ERR);
			break;

		case '>':
		case ':':
			doemt(buf);
			break;

		case '%':
			dopercen(&buf[1]);
			break;

		default:
			diag("no such command %c%s", cmdch, buf);
			msg("(use `%c%c' to start line with `%c')", cmdch, cmdch, cmdch);
			break;
	}

	return(OK);
}

help() {
	register int i;

	msg("available %c escapes:", cmdch);
	for (i = 0; hlp[i] != NULL; i++)
		msg(hlp[i], cmdch);
}

pump(cmd)
char *cmd;
{
	register int child;
	register char *shell;

	while ((child = fork()) == -1) {
		diag("couldn't fork, retrying...");
		sleep(1);
	}
	if (child == 0) {
		if ((shell = getenv("SHELL")) == NULL)
			shell = "/bin/sh";
		close(1);
		dup(cmd[0] == '$' ? ln : 2);
		close(ln);
		tty(T_NORM);
		if (nhup == SIG_DFL)
			(void) signal(SIGINT, SIG_DFL);
		if (cmd[1] == NULL) {
			cmd = rindex(shell)+1;
			execl(shell, cmd, NULL);
		}
		else
			execl(shell, "sh", "-c", &cmd[1], NULL);
		diag("exec error: %s: %s", shell, sys_errlist[errno]);
		exit(EX_UNAVAILABLE);
	}
	else
		while (child != wait(0));

	tty(T_RAW);
	if (cmd[0] == '!')
		msg("!");
}

doemt(nam)
char *nam;
{
	extern bool verify();
	register file *fid;

	if ((nam[0] == '>') && (nam[1] != NULL)) {
		if (! verify(nam+1))
			return;
	}

	sprintf(wrtmpbuf, "/tmp/%s%d", argv0, rdpid);
	if ((fid = fopen(wrtmpbuf, "w")) == NULL) {
		diag("fopen error: %s: %s", wrtmpbuf, sys_errlist[errno]);
		return;
	}
	fprintf(fid, "%s", nam);
	if (dflg)
		diag("doemt: name to be written in temporary: %s", nam);
	fclose(fid);
	kill(rdpid, SIGEMT);
}

dopercen(str)
register char *str;
{
	extern char *gethome();
	char *args[3];
	file *fid;
	int tmpspd;
	int ch;
	auto rcnt;
	auto narg;
	auto len;

	/* eat leading spaces */
	while (isspace(*str))
		str++;

	/* eat trailing spaces */
	len = strlen(str) - 1;
	while (isspace(str[len])) {
		str[len] = NULL;
		len--;
	}

	for (narg = 0; narg < 3; narg++) {
		args[narg] = str;
		while ((*str != NULL) && !isspace(*str))
			str++;
		if (*str == NULL)
			break;
		*str++ = NULL;
		while (isspace(*str))
			str++;
	}

	if (eql(args[0], "take")) {
		if (narg < 1) {
			diag("usage: %c%%take from [to]", cmdch);
			return;
		}
		if (narg < 2)
			args[2] = args[1];
		if (! verify(args[2]))
			return;
		remout("echo '~>:'");
		remout(args[2]);
		remout(";tee /dev/null<");
		remout(args[1]);
		remout(";echo '~>'\n");
	}
	else if (eql(args[0], "put")) {
		if (narg < 1) {
			diag("usage: %c%%put from [to]", cmdch);
			return;
		}
		if (narg < 2)
			args[2] = args[1];
		if ((fid = fopen(args[1], "r")) == NULL) {
			diag("fopen error: %s: %s", args[1], sys_errlist[errno]);
			return;
		}
		remout("stty -echo;cat>");
		remout(args[2]);
		remout(";stty echo\n");
		sleep(5);
		wrintr = FALSE;
		if (nhup == SIG_DFL)
			(void) signal(SIGINT, wrsig2);
		tty(T_SLNT);
		rcnt = 0;
		while ((ch = getc(fid)) != EOF) {
			if (wrintr)
				break;
			rcnt++;
			if (dflg)
				if ((rcnt % 512) == 0)
					putc('.', stdout);

			if ((ch == tkill) || (ch == terase))
				write(ln, "\\", CHRSIZ);
			if (write(ln, (char *) &ch, CHRSIZ) != CHRSIZ) {
				sleep(2);
				if (write(ln, (char *) &ch, CHRSIZ) != CHRSIZ) {
					diag("character missed");
					wrintr = TRUE;
					break;
				}
			}
		}
		(void) signal(SIGINT, SIG_IGN);
		if (wrintr || ferror(fid)) {
			write(ln, "\n", CHRSIZ);
			diag("stopped after %d bytes", rcnt);
		}
		fclose(fid);
		write(ln, "\004", CHRSIZ);
		sleep(3);
		tty(T_RAW);
		remout("\n");
	}
	else if (eql(args[0], "cd")) {
		if (narg > 1) {
			diag("usage: %c%%cd dir", cmdch);
			return;
		}
		if (narg == 0) {
			if ((args[1] = gethome()) == NULL) {
				diag("can't find your home dir");
				return;
			}
		}
		if (chdir(args[1]) == -1) {
			diag("chdir error: %s: %s", args[1], sys_errlist[errno]);
			return;
		}
		efork();
		remout("\n");
	}
	else if (eql(args[0], "speed")) {
		if (narg != 1) {
			diag("usage: %c%%speed baud_rate", cmdch);
			return;
		}
		tmpspd = atoi(args[1]);
		if (spdchk(tmpspd, TRUE) == ERR) {
			diag("invalid speed: %s", args[1]);
			return;
		}
		remout("stty ");
		remout(args[1]);
		remout("\n");
		sleep(4);
		line(L_SPEED);
		remout("\n");
	}
	else if (eql(args[0], "tandem")) {
		if (narg != 0) {
			diag("usage: %c%%tandem", cmdch);
			return;
		}
		line(L_TAND);
		remout("\n");
	}
	else if (eql(args[0], "notandem")) {
		if (narg != 0) {
			diag("usage: %c%%notandem", cmdch);
			return;
		}
		line(L_NOTAND);
		remout("\n");
	}
	else
		diag("~%%%s: unknown command", args[0]);
}

bool
verify(nam)
char *nam;
{
	bool ovrwr;
	char ch;

	ovrwr = TRUE;
	if (dflg)
		diag("verify: nam=%s", nam);
	if (access(nam, 0) == 0) {
		ovrwr = FALSE;
		echo("overwrite %s? ", nam);
		do {
			read(0, &ch, CHRSIZ);
			putc(ch, stdout);
			if ((ch == ' ') || (ch == '\t'))
				continue;
			if ((ch == 'y') || (ch == 'Y'))
				ovrwr = TRUE;
		} while ((ch != '\n') && (ch != '\r'));
		msg("");
	}

	return(ovrwr);
}

# include <pwd.h>

char *
gethome() {
	extern char *getenv();
	extern struct passwd *getpwuid();
	struct passwd *pw;
	char *cp;

	if ((cp = getenv("HOME")) != NULL)
		return(cp);

	if ((pw = getpwuid(getuid())) == NULL)
		return(NULL);

	return(pw->pw_dir);
}

wrsig2() {
	(void) signal(SIGINT, SIG_IGN); 
	wrintr = TRUE;
}
