/* penconn.c	1.5	(CARL)	1/3/84	15:53:15 */

static char Sccsid[] = "@(#)penconn.c 1.5 (CARL) 1/3/84";

# ifdef PEN
# include <signal.h>
# include <setjmp.h>
# include <errno.h>
# include <sgtty.h>
# include <ctype.h>
# include <sys/time.h>
# include <stdio.h>
# include "catt.h"
# include "conn.h"

/*
 * penril dialer connect routine.
 */

# define STBNULL	((struct sgttyb *) NULL)

/*
 * default speed for penril
 * dialer
 */
# define PENSPEED	1200

/*
 * available devices for a
 * penril dialer connection
 */
struct conndev pendev[] = {
	{ "/dev/acu0",	PENSPEED },
	{ 0,		0 }		/* last entry must be zeros */
};

static char penusage[] = "usage: %s [ -t ] [ -lline ] [ -sspeed ] telno";

static jmp_buf sig14jb;

static char penmsgbuf[BUFSIZ];

static jmp_buf sig2jb;

static int	penspeed;

char *
penconn(ctp, speed, argerr)
struct conntab *ctp;
bool argerr;
{
	extern struct telno *curc();
	extern char *pendial();
	struct telno *tp;
	char *cp;

	if ((ctp->c_telno == NULL) || argerr) {
		sprintf(penmsgbuf, penusage, ctp->c_name);
		return(penmsgbuf);
	}

	/*
	 * if the phone number contains non-numerics
	 * then it is an alias. '=' is special because
	 * it is used to tell the penril dialer to wait
	 * for an intermediate dial tone.
	 */
	tp = NULL;
	for (cp = ctp->c_telno; *cp != NULL; cp++) {
		if (! isdigit(*cp)) {
			if (*cp != '=') {
				if ((tp = curc(ctp->c_telno)) == NULL)
					return("bad phone number");
				break;
			}
		}
	}

	/*
	 * no alias, dial the
	 * supplied phone number
	 */
	if (tp == NULL)
		return(pendial(ctp, speed));

	/*
	 * dial each phone number in the
	 * tp list. when we break out of
	 * the for loop cp will contain
	 * the proper error message.
	 */
	for (;;) {
		ctp->c_telno = tp->t_telno;
		if ((cp = pendial(ctp, speed)) != penmsgbuf)
			break;

		if ((tp = tp->t_next) == NULL)
			break;
		else
			diag(cp);
	}

	return(cp);
}

char *
pendial(ctp, speed)
struct conntab *ctp;
{
	extern int pensig14();
	extern char *index();
	extern int pensig2();
	struct conndev *cdp;
	struct sgttyb stbuf;
	int (*osig14)();
	char phbuf[60];
	int lspeed;
	int oerrno;
	char *cp;
	char ch;

	strcpy(penmsgbuf, "dial failed");

	signal(SIGINT, pensig2);
	if (setjmp(sig2jb)) {
		lnclose();
		return("interrupted");
	}

	for (cdp = ctp->c_dev; cdp->d_dev != NULL; cdp++) {
		if (sflg)
			cdp->d_speed = speed;
		if (cdp->d_speed == 0)
			cdp->d_speed = PENSPEED;
		if ((lspeed = spdchk(cdp->d_speed, sflg)) == ERR)
			return("bad speed");

		oerrno = errno;
		if (access(cdp->d_dev, 6) != 0) {
			if (errno == ENOENT)
				errno = oerrno;
			continue;
		}

		if ((ln = open(cdp->d_dev, 2)) != -1)
			break;
	}

	if (cdp->d_dev == NULL)
		return(noaccess(penmsgbuf, "dialer"));

	if (ln == -1)
		return("dialer in use"); 

	if (ioctl(ln, TIOCEXCL, STBNULL) == -1)
		goto iocerr;
	if (ioctl(ln, TIOCHPCL, STBNULL) == -1)
		goto iocerr;

	if (ioctl(ln, TIOCGETP, &stbuf) == -1)
		goto iocerr;
	stbuf.sg_ispeed = lspeed;
	stbuf.sg_ospeed = lspeed;
	stbuf.sg_flags = (EVENP | ODDP | CBREAK | (tflg ? TANDEM : 0));
	if (ioctl(ln, TIOCSETP, &stbuf) == -1) {
	iocerr:	lnclose();
		return("ioctl error");
	}

	penspeed = lspeed;

	aculog("%s, ", ctp->c_telno);

	/*
	 * give penril time to wake up
	 */
	sleep(1);

	/*
	 * turn `=' and `-' into wait command
	 */
	while ((cp = index(ctp->c_telno, '=')) != NULL)
		*cp = 'w';
	while ((cp = index(ctp->c_telno, '-')) != NULL)
		*cp = 'w';

	msg("dialing...");

	/*
	 * start penril talking to us
	 */
	if (penwr("\r", ln) == ERR)
		goto penerr;
	if (penexpect("PENRIL", ln) == ERR)
		goto penerr;
	if (penexpect(">", ln) == ERR)
		goto penerr;

	/*
	 * disable escape char
	 */
	if (penwr("q", ln) == ERR)
		goto penerr;
	if (penexpect("NEW CODE:", ln) == ERR)
		goto penerr;
	if (penwr("-", ln) == ERR)
		goto penerr;
	if (penexpect(">", ln) == ERR)
		goto penerr;

	/*
	 * turn off auto text mode
	 */
	if (penwr("t-", ln) == ERR)
		goto penerr;
	if (penexpect(">", ln) == ERR)
		goto penerr;

	/*
	 * clear the directory
	 */
	if (penwr("c", ln) == ERR)
		goto penerr;
	if (penexpect("SURE? (Y/N)", ln) == ERR)
		goto penerr;
	if (penwr("y", ln) == ERR)
		goto penerr;
	if (penexpect(">", ln) == ERR)
		goto penerr;

	/*
	 * store the number
	 */
	if (penwr("s1", ln) == ERR)
		goto penerr;
	if (penexpect("NO.:", ln) == ERR)
		goto penerr;
	if (penwr("t", ln) == ERR)	/* use tone dialing */
		goto penerr;
	if (penwr(ctp->c_telno, ln) == ERR)
		goto penerr;
	if (penwr("\r", ln) == ERR)
		goto penerr;
	if (penexpect(">", ln) == ERR)
		goto penerr;

	/*
	 * dial the number
	 */
	if (penwr("1", ln) == ERR)
		goto penerr;
	if (penexpect("DIALING:", ln) == ERR)
		goto penerr;

	osig14 = signal(SIGALRM, pensig14);
	if (setjmp(sig14jb)) {
		if (dflg) {
			diag("pendial: got %s", phbuf);
			diag("(read timeout)");
		}
		goto penerr;
	}

	if (dflg)
		echo("pendial: flushing ");

	alarm(60);
	while (read(ln, &ch, 1) == 1) {
		if (dflg)
			echo("%c", ch & 0177);
		if (ch == '\n') {
			if (dflg)
				echo("\n");
			break;
		}
	}

	for (cp = &phbuf[0]; cp < &phbuf[sizeof(phbuf)]; cp++)
		*cp = NULL;
	cp = &phbuf[0];
	while (cp < &phbuf[sizeof(phbuf)]) {
		if (read(ln, &ch, 1) <= 0) {
			sprintf(penmsgbuf, "dial failed: %s", "lost line");
			goto penerr;
		}
		if (dflg)
			if (isprint(ch) || (ch == ' '))
				echo("%c", ch);
			else
				echo("^%c", ch+'@');
		if (ch == '\n')
			break;
		if (ch != '\r')
			*cp++ = ch & 0177;
	}

	if (cp < &phbuf[sizeof(phbuf)])
		*cp = NULL;

	if (strcmp(phbuf, "OK") != 0) {
		for (cp = &phbuf[0]; cp < &phbuf[sizeof(phbuf)]; cp++) {
			if (*cp == NULL)
				break;
			if (isupper(*cp))
				*cp = tolower(*cp);
		}
		sprintf(penmsgbuf, "dial failed: %s", phbuf);
		goto penerr;
	}

	signal(SIGALRM, osig14);
	alarm(0);

	aculog("succeeded\n");

	return(NULL);

penerr:
	signal(SIGALRM, osig14);
	alarm(0);

	lnclose();
	aculog("dial failed\n");
	return(penmsgbuf);
}

penexpect(str, fd)
char *str;
{
	extern int pensig14();
	int (*osig14)();
	char penbuf[80];
	int len;
	char *cp, *cp2;
	char ch;

	osig14 = signal(SIGALRM, pensig14);
	if (setjmp(sig14jb)) {
		if (dflg) {
			echo("\n");
			diag("(read timeout)");
		}
		return(ERR);
	}

	len = strlen(str);

	if (dflg) {
		diag("penexpect: expect %s", str);
		echo("penexpect: got ");
	}

	alarm(120);

	/*
	 * read up penril response, masking
	 * off any garbage.
	 */
	/*for (cp = &penbuf[0]; cp < &penbuf[sizeof(penbuf)]; cp++)
		*cp = NULL;*/
	cp = &penbuf[0];
	while (cp < &penbuf[sizeof(penbuf)]) {
		if (read(fd, &ch, 1) != 1)
			return(ERR);
		*cp++ = ch & 0177;

		if (dflg) {
			if (isprint(ch) || (ch == ' '))
				echo("%c", ch);
			else
				echo("^%c", ch+'@');
		}

		/*
		 * walk through penbuf and see if str is in
		 * it anywhere.
		 */
		/*if (len > (cp - &penbuf[0]))
			continue;*/
		for (cp2 = &penbuf[0]; cp2 < &penbuf[sizeof(penbuf)]; cp2++) {
			if (*cp2 == NULL)
				break;
			if (strncmp(str, cp2, len) == 0) {
				alarm(0);
				signal(SIGALRM, osig14);
				if (dflg)
					echo("\n"); /* for newline */
				return(OK);
			}
		}
	}

	alarm(0);
	signal(SIGALRM, osig14);

	if (dflg)
		echo("\n"); /* for newline */

	return(ERR);
}

penwr(str, fd)
char *str;
{
	register char *cp;

	if (dflg)
		diag("penwr: sending %s", str);

	for (cp = str; *cp != NULL; cp++) {
		if (write(fd, cp, 1) != 1) {
			aculog("acu write error");
			return(ERR);
		}
		if (penspeed < B1200) {
			if (dflg)
				diag("penwr: sleeping a bit more");
			sleep(1);
		}
		sleep(1);
	}

	return(OK);
}

static int
pensig2() {

	(void) signal(SIGINT, SIG_IGN);
	aculog("interrupted\n");
	longjmp(sig2jb, 1);
}

static int
pensig14() {
	signal(SIGALRM, pensig14);
	longjmp(sig14jb, 1);
}
# endif PEN
