/* lnio.c	1.7	(CARL)	1/4/83	16:27:35 */

static char SID_lnio[] = "@(#)lnio.c 1.7 (CARL) 1/4/83";

# include <sgtty.h>
# include <stdio.h>
# include "catt.h"

# define BSPEED	B150

/*
 * routines to do various things
 * with the communications line
 */

static int lspeed = -1;

/*
 * send str out to the
 * communications line.
 */
remout(str)
register char *str;
{
	write(ln, str, strlen(str));
}

/*
 * change parameters on
 * communications line
 */
line(set) {
	struct sgttyb stbuf;

	if (ioctl(ln, TIOCGETP, &stbuf) == -1)
		diag("ioctl error: %s", sys_errlist[errno]);

	switch (set) {
		case L_SPEED:
			stbuf.sg_ispeed = lspeed;
			stbuf.sg_ospeed = lspeed;
			break;

		case L_TAND:
			stbuf.sg_flags |= TANDEM;
			tflg = TRUE;
			break;

		default:
			break;
	}

	if (ioctl(ln, TIOCSETP, &stbuf) == -1)
		diag("ioctl error: %s", sys_errlist[errno]);
}

/*
 * check to see that the requested
 * speed is valid. side effect: sets
 * variable "lspeed" for line().
 */
struct speeds {
	int ival;
	int uval;
} speeds[] = {
	{   50, B50   },
	{   75, B75   },
	{  110, B110  },
	{  134, B134  },
	{  150, B150  },
	{  200, B200  },
	{  300, B300  },
	{  600, B600  },
	{ 1200, B1200 },
	{ 1800, B1800 },
	{ 2400, B2400 },
	{ 4800, B4800 },
	{ 9600, B9600 },
	{ 0, 0 }
};

spdchk(spd, force)
int spd;
{
	register struct speeds *sp;
	struct sgttyb stbuf;
	static int nspeed = 0;

	for (sp = &speeds[0]; sp->ival != 0; sp++) {
		if (spd == sp->ival) {
			lspeed = sp->uval;
			break;
		}
	}

	if (sp->ival == 0)
		return(ERR);

	/*
	 * if the default line speed is faster than
	 * the speed that the user's terminal is
	 * running at then we'll use the speed that
	 * their terminal is running at.
	 */
	if (! force) {
		if (ioctl(fileno(stdout), TIOCGETP, &stbuf) != -1) {
			if (lspeed > stbuf.sg_ospeed) {
				lspeed = stbuf.sg_ospeed;

				/*
				 * this is just to get a printable
				 * value of the speed
				 */
				for (sp = &speeds[0]; sp->ival != 0; sp++) {
					if (lspeed == sp->uval)
						break;
				}
				if ((nspeed != sp->ival) && (sp->ival != 0)) {
					msg("(using %d baud)", sp->ival);
					nspeed = sp->ival;
				}
			}
		}
	}

	return(lspeed);
}

/*
 * send out a bunch of nulls and
 * try to fake a break. similar
 * to the way that uucp does it.
 */
sendbrk(nlen) {
	struct sgttyb ttyb;
	int ospeed;
	char *nulls;

	if (ioctl(ln, TIOCGETP, &ttyb) == -1)
		goto iocerr;

	/*
	 * botch in dz driver makes us set both
	 * ospeed and ispeed
	 */
	ospeed = ttyb.sg_ospeed;
	ttyb.sg_ospeed = ttyb.sg_ispeed = BSPEED;
	if (ioctl(ln, TIOCSETP, &ttyb) == -1)
		goto iocerr;

	if ((nlen > 12) || (nlen < 0))
		nlen = 6;

	/*
	 * alloc zeroes the buffer before
	 * returning its address.
	 */
	nulls = alloc(nlen);
	if (write(ln, nulls, nlen) != nlen) {
		diag("write error: %s", sys_errlist[errno]);
		return;
	}
	ttyb.sg_ospeed = ttyb.sg_ispeed = ospeed;
	if (ioctl(ln, TIOCSETP, &ttyb) == -1) {
	iocerr:	diag("ioctl error: %s", sys_errlist[errno]);
		return;
	}

	free(nulls);
}

lnclose() {
	struct sgttyb stbuf;

	if (ln == -1)
		return;

	if (devreset != NULL)
		(*devreset)();

	stbuf.sg_ispeed = 0;
	stbuf.sg_ospeed = 0;
	ioctl(ln, TIOCSETP, &stbuf);
	close(ln);
}
