/* conn.c	1.7	(CARL)	5/5/83	10:53:37 */

static char SID_conn[] = "@(#)conn.c 1.7 (CARL) 5/5/83";


# include <sgtty.h>
# include <stdio.h>
# include "catt.h"
# include "conn.h"

# define NCONNTAB	(sizeof(conntab) / sizeof(conntab[0]))

# ifdef DIR
extern char *dirconn();
extern struct conndev pdpdev[];
extern struct conndev vaxdev[];
extern struct conndev sundev[];
# endif DIR

# ifdef DSW
extern char *dswconn();
extern struct conndev dswdev[];
# endif DSW

# ifdef VAD
extern char *vadconn();
extern struct conndev vaddev[];
# endif VAD

# ifdef PEN
extern char *penconn();
extern struct conndev pendev[];
# endif PEN

struct conntab conntab[] = {
# ifdef DSW
	{ "dswitch",	"0",	&dswdev[0],	dswconn },
# endif DSW
# ifdef VAD
	{ "cu",		"0",	&vaddev[0],	vadconn },
# endif VAD
# ifdef PEN
	{ "cu",		"0",	&pendev[0],	penconn },
# endif PEN
# ifdef DIR
	{ "pdp",	"0",	&pdpdev[0],	dirconn },
	{ "vax",	"0",	&vaxdev[0],	dirconn },
	{ "sun",	"0",	&sundev[0],	dirconn },
# endif DIR
};

static struct conndev cdev[] = {
	{ 0, 0 },
	{ 0, 0 }
};

char *
conn(name, dev, speed, telno, argerr)
char *name, *dev, *telno;
bool argerr;
{
	register struct conntab *ctp;
	register int i;

	for (ctp = &conntab[0]; ctp < &conntab[NCONNTAB]; ctp++) {
		if (eql(name, ctp->c_name))
			break;
	}

	/*
	 * we default to a dataswitch
	 * connection if no match was
	 * made on the name because the
	 * dataswitch routine uses argv[0]
	 * as the name of the machine to
	 * connect to.
	 */
	if (ctp == &conntab[NCONNTAB]) {
# ifdef DSW
		for (i = 0; i < NCONNTAB; i++) {
			if (conntab[i].c_connf == dswconn) {
				ctp = &conntab[i];
				ctp->c_name = name;
				break;
			}
		}
# else DSW
		return("unknown connect type");
# endif DSW
	}

	if (dev != NULL) {
		cdev[0].d_dev = dev;
		cdev[0].d_speed = 0;
		ctp->c_dev = &cdev[0];
	}

	ctp->c_telno = telno;

	return((*ctp->c_connf)(ctp, speed, argerr));
}
