# %M%	%I%	(CARL)	%G%	%U%

include(/usr/local/include/carl/config.m4)dnl

# use OPTS to:
# define DIR if you are using a direct connection
# define DSW if you are using the dataswitch
# define VAD if you are using a vadic dialer
# define PEN if you are using a penril dialer
OPTS =		-DDIR -DDSW -DPEN

PROG =		catt
SRCDIR =	m4SRCDIR/${PROG}
DESTDIR =	m4DESTDIR
CFLAGS =	${OPTS} ${DBFLAGS} -O
LDFLAGS =	${DBFLAGS}
DBFLAGS =	# -Ddebug -g
SRC =		main.c rd.c wr.c lnio.c curc.c util.c data.c aculog.c \
		conn.c vadconn.c dswconn.c dirconn.c penconn.c
OBJ =		main.o rd.o wr.o lnio.o curc.o util.o data.o aculog.o \
		conn.o vadconn.o dswconn.o dirconn.o penconn.o
# MACHINES =	catta cattb su3 s3 sv2 s5 s6 eecs phonlab amos cu pdp vax
MACHINES =	cu

${PROG}:	${OBJ}
		cc -o ${PROG} ${LDFLAGS} ${OBJ}

${OBJ}:		catt.h conn.h

Readme ${SRC} catt.h conn.h:
		sccs get -s $@

install:	${PROG}
		for file in ${PROG} ${MACHINES} ; do rm -f ${DESTDIR}/$${file} ; done
		mv catt ${DESTDIR}
		for file in ${MACHINES} ; do ln ${DESTDIR}/${PROG} ${DESTDIR}/$${file} ; done

lint:		${SRC} catt.h conn.h
		lint -hbaxcp ${OPTS} ${SRC}

tags:		${SRC}
		ctags ${SRC}

tar:		Readme makefile catt.h conn.h ${SRC}
		tar crf catt.tar Readme makefile catt.h conn.h ${SRC}

pub:		Readme Makefile.m4 catt.h conn.h ${SRC}
		rm -f ${SRCDIR}/*
		cp Readme Makefile.m4 catt.h conn.h ${SRC} ${SRCDIR}

clean:
		rm -f errs tags a.out *.o
		sccs clean
