/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <signal.h>
# include <stdio.h>
# include "client.h"
# include "aswdaemon.h"

/*
 * termination via termination signal
 */

die() {
	blocksigs();

	info(INFO_INFO, "die: aswdaemon shutting down");

	/*
	 * a bug in 4.2bsd will cause the system
	 * to hang if a client process is connected
	 * to this socket and we exit without shutting
	 * down the sockets.
	 */

	if (shutdown(sock, 2) == -1)
		err(ERR_IPC, "die: shutdown(sock): %m");

	if (client.cl_sock != -1) {
		if (shutdown(client.cl_sock, 2) == -1)
			err(ERR_IPC, "die: shutdown(cl_sock): %m");
	}

	exit(0);
}
