/* aswsock.c	1.7	(CARL)	4/16/85	23:52:27 */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <arpa/inet.h>
# include <netdb.h>
# include <stdio.h>
# include "switch.h"
# include "aswdaemon.h"

# define DEBUGPORT	2345

/*
 * aswsock
 *
 * aswsock sets up the master socket that clients
 * connect to when requesting a service.
 *
 * we use the internet address format (AF_INET) and
 * the stream type (SOCK_STREAM).
 *
 * the aswdaemon is expected to be run on the host
 * hostnam (e.g. "aswhost") and have its port number
 * in the file /etc/services.
 */
aswsock() {
	register struct servent *sp;
	register struct hostent *hp;
	struct sockaddr_in sin;
	char buf[BUFSIZ];

retry:	bzero((char *) &sin, sizeof(sin));

	/*
	 * if lconn is non-zero then connections are
	 * restricted to machines that are only on the
	 * network given in hp->h_addr. otherwise any
	 * machine can connect to the daemon.
	 */
	if (lconn) {
		/*
		 * get the family and address of the host
		 * that the asw daemon runs on from the
		 * /etc/hosts file.
		 */
		if ((hp = gethostbyname(hostnam)) == NULL) {
			err(ERR_IPC, "aswsock: no such host: %s", hostnam);
			if (strcmp(hostnam, lhostnam) == 0)
				return(RET_ERR);

			strcpy(hostnam, lhostnam);
			goto retry;
		}
		sin.sin_family = hp->h_addrtype;
		sin.sin_addr = inet_makeaddr(inet_netof(*(struct in_addr *) hp->h_addr), INADDR_ANY);
	}
	else {
		sin.sin_family = AF_INET;
		sin.sin_addr = inet_makeaddr(0, INADDR_ANY);
	}

	/*
	 * get the port number of the asw daemon from the /etc/services
	 * file. default service is "aswdaemon". if there is more than
	 * one daemon then the name of the service is constructed by
	 * appending the service type to the string "aswdaemon-". for
	 * example at CARL we use the type "ss" so we could put the
	 * service name "aswdaemon-ss" in /etc/services.
	 */
	sprintf(buf, "aswdaemon");
	if ((sp = getservbyname(buf, sw->sw_proto)) == NULL) {
		info(INFO_IPC, "aswsock: no such service: %s", buf);
		sprintf(buf, "aswdaemon-%s", sw->sw_type);
		if ((sp = getservbyname(buf, sw->sw_proto)) == NULL) {
			err(ERR_IPC, "aswsock: no such service: %s/%s", buf, sw->sw_proto);
			return(RET_ERR);
		}
	}

	sin.sin_port = sp->s_port;

	if (debug_mode) {
		info(INFO_IPC, "aswsock: using port %d", DEBUGPORT);
		sin.sin_port = htons(DEBUGPORT);
	}

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		err(ERR_IPC, "aswsock: socket: %m");
		return(RET_ERR);
	}

	if (bind(sock, (struct sockaddr *) &sin, sizeof(sin)) == -1) {
		err(ERR_IPC, "aswsock: bind: %m");
		if (strcmp(hostnam, lhostnam) == 0)
			return(RET_ERR);

		/*
		 * klunky, but it helps when the net is down
		 */
		info(INFO_IPC, "aswsock: trying host %s", lhostnam);
		strcpy(hostnam, lhostnam);
		goto retry;
	}

	if (listen(sock, NCLIENTS) == -1) {
		err(ERR_IPC, "aswsock: listen: %m");
		return(RET_ERR);
	}

	return(RET_OK);
}
