h28419
s 00078/00003/00077
d D 1.6 85/05/10 22:38:05 rusty 6 5
c added "interval" routine that gets called on SIGALRM
e
s 00004/00006/00076
d D 1.5 84/07/24 13:01:26 rusty 5 4
c changed error messages to use bits in elevel instead of ranges of values
e
s 00021/00019/00061
d D 1.4 84/07/24 12:01:59 rusty 4 3
c redid reconfiguration signal, got rid of unused reaper routine
e
s 00002/00002/00078
d D 1.3 84/04/24 12:17:15 rusty 3 2
c changed config routine to cfget
e
s 00004/00031/00076
d D 1.2 84/04/06 13:40:59 rusty 2 1
c numerous bug fixes trying to fix the "lost memory" (the size of
c the daemon slowly grows; something that was malloc'd isn't being free'd).
c it isn't fixed yet but at least less memory is being lost. also general
c clean-up type of bug fixes.
e
s 00107/00000/00000
d D 1.1 84/04/05 14:10:07 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

D 4
# include <sys/wait.h>
# include <sys/time.h>
# include <sys/resource.h>
E 4
I 4
# include <sys/types.h>
I 6
# include <sys/time.h>
E 6
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
E 4
# include <signal.h>
# include <stdio.h>
I 4
# include "client.h"
E 4
# include "aswdaemon.h"

/*
 * stuff for catching, ignoring, etc.
 * signals.
 */

# define NULLVEC	((struct sigvec *) 0)
I 6
# define IVTIME		(5*60)			/* 5 minutes */
E 6

D 4
extern int reaper();
D 3
extern int config();
E 3
I 3
extern int cfget();
E 4
I 4
D 6
extern int reconf();
E 4
E 3
extern int die();
E 6
I 6
extern int	reconf();
extern int	die();
extern int	interval();
E 6

/*
 * what to do with various
 * signals
 */
struct sigvecs {
	int	sg_signal;
	struct	sigvec sg_sigvec;
};

/*
 * what to do with various
 * signals
 */
struct sigvecs sigvecs[] = {
D 4
	{ SIGCHLD,	{ reaper,	0,	0 } },
D 3
	{ SIGHUP,	{ config,	0,	0 } },
E 3
I 3
	{ SIGHUP,	{ cfget,	0,	0 } },
E 4
I 4
	{ SIGHUP,	{ reconf,	0,	0 } },
E 4
E 3
	{ SIGTERM,	{ die,		0,	0 } },
I 6
	{ SIGALRM,	{ interval,	0,	0 } },
E 6
	{ 0,		{ 0,		0,	0 } }
};

/*
I 6
 * what to do when the interval timer goes off
 */
struct ivfuncs {
	char		*(*iv_func)();		/* returns a string	 */
	struct ivfuncs	*iv_next;		/* next function to call */
};

struct ivfuncs	*ivfuncs;

/*
E 6
 * block, ignore, catch, etc.
 * various signals.
 */
setsigs() {
D 6
	register struct sigvecs *sg;
E 6
I 6
	register struct sigvecs	*sg;
	struct itimerval	ivtime;
E 6

	for (sg = &sigvecs[0]; sg->sg_signal != 0; sg++) {
		if (sigvec(sg->sg_signal, &sg->sg_sigvec, NULLVEC) == -1)
D 5
			err(1, "setsigs: sigvec(%d): %m", sg->sg_signal);
E 5
I 5
			err(ERR_SYSTEM, "setsigs: sigvec(%d): %m", sg->sg_signal);
E 5
	}
I 6

	/*
	 * set up the interval timer (SIGALRM)
	 */
	ivtime.it_interval.tv_sec = IVTIME;
	ivtime.it_value.tv_sec = IVTIME;

	setitimer(ITIMER_REAL, &ivtime, (struct itemerval *) 0);
E 6
}

/*
D 4
 * reaper catches all child processes that
 * have terminated. it outputs a message
 * if the process died abnormally.
E 4
I 4
 * reconfigure the daemon
E 4
 */
D 4
reaper() {
	extern char *signam();
	register int sig;
	register int pid;
	union wait status;
E 4
I 4
reconf() {
	if (shutdown(sock, 2) == -1)
D 5
		err(1, "reconf: shutdown(sock): %m");
E 5
I 5
		err(ERR_IPC, "reconf: shutdown(sock): %m");
E 5
E 4

D 4
	while ((pid = wait3(&status, WNOHANG, (struct rusage *) 0)) != -1) {
		if ((sig = status.w_termsig) != 0)
			info(2, "reaper: pid %d: %s", pid, signam(sig));
		info(3, "reaper: pid %d done", pid);
E 4
I 4
	if (client.cl_sock != -1) {
		if (shutdown(client.cl_sock, 2) == -1)
D 5
			err(1, "reconf: shutdown(cl_sock): %m");
E 5
I 5
			err(ERR_IPC, "reconf: shutdown(cl_sock): %m");
E 5
	}

	cfget();

D 5
	if (aswsock() == RET_ERR) {
		err(1, "reconf: can't open socket");
E 5
I 5
	if (aswsock() == RET_ERR)
E 5
		exit(1);
I 6
}

/*
 * interval calls each of the functions in the
 * ivfuncs list when we get a SIGALRM signal.
 */
interval() {
	register struct ivfuncs	*iv;

	for (iv = ivfuncs; iv != NULL; iv = iv->iv_next)
		(void) (*iv->iv_func)();
}

/*
 * ivadd adds a function to the list of
 * functions to be called by interval.
 */
ivadd(pf)
	char	*(*pf)();
{
	register struct ivfuncs	*lastiv;
	register struct ivfuncs	*iv;

	if (ivfuncs == NULL) {
		if ((iv = (struct ivfuncs *) malloc(sizeof(struct ivfuncs))) == NULL) {
			err(ERR_SYSTEM, "ivadd: malloc failed");
			return(RET_ERR);
		}

		iv->iv_func = pf;
		iv->iv_next = NULL;

		ivfuncs = iv;

		return(RET_OK);
	}

	/*
	 * find end of list
	 */
	for (iv = ivfuncs; iv != NULL; iv = iv->iv_next)
		lastiv = iv;

	/*
	 * add to end
	 */
	iv->iv_func = pf;
	iv->iv_next = NULL;

	lastiv->iv_next = iv;

	return(RET_OK);
E 6
E 4
D 5
	}
E 5
}

char *
signam(sig) {
D 2
	static struct signams {
		int	sg_sig;
		char	*sg_name;
	} signams[] = {
		SIGHUP,		"hangup",
		SIGINT,		"interrupt",
		SIGQUIT,	"quit",
		SIGILL,		"illegal instruction",
		SIGTRAP,	"trace/bpt trap",
		SIGIOT,		"iot trap",
		SIGEMT,		"emt trap",
		SIGFPE,		"floating exception",
		SIGKILL,	"killed",
		SIGBUS,		"bus error",
		SIGSEGV,	"segmentation fault",
		SIGSYS,		"bad system call",
		SIGPIPE,	"broken pipe",
		SIGALRM,	"alarm clock",
		SIGTERM,	"terminated",
		SIGXCPU,	"cpu time limit exceeded",
		SIGXFSZ,	"file size limit exceeded",
		SIGVTALRM,	"virtual time alarm",
		SIGPROF,	"profiling time alarm",
		0,		NULL,
	};
	register struct signams *sg;
E 2
I 2
	extern char *sys_siglist[];
E 2

D 2
	for (sg = &signams[0]; sg->sg_name != NULL; sg++) {
		if (sg->sg_sig == sig)
			return(sg->sg_name);
	}
E 2
I 2
	if (sig >= NSIG)
		return("unknown signal");
E 2

D 2
	return("unknown signal");
E 2
I 2
	return(sys_siglist[sig]);
E 2
}
E 1
