h26603
s 00017/00000/00307
d D 1.10 85/04/25 11:36:31 rusty 10 9
c added "dump" command
e
s 00013/00000/00294
d D 1.9 85/03/14 16:14:53 rusty 9 8
c mods for "init" command
e
s 00008/00008/00286
d D 1.8 84/07/24 13:41:25 rusty 8 7
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00006/00006/00288
d D 1.7 84/07/24 13:01:20 rusty 7 6
c changed error messages to use bits in elevel instead of ranges of values
e
s 00026/00025/00268
d D 1.6 84/07/24 12:20:49 rusty 6 5
c changed debugging to use bits in ilevel instead of ranges of values
e
s 00044/00029/00249
d D 1.5 84/04/25 15:45:28 rusty 5 4
c many fixes to essentially add a new class of symbols to the symbol
c table; the class of variables. possibly other cosmetic changes
e
s 00002/00002/00276
d D 1.4 84/04/24 11:53:09 rusty 4 3
c added error message for unknown symbolic channel
e
s 00016/00002/00262
d D 1.3 84/04/07 10:43:14 rusty 3 2
c fixes to code setting the type of a number list
e
s 00042/00012/00222
d D 1.2 84/04/06 13:40:30 rusty 2 1
c numerous bug fixes trying to fix the "lost memory" (the size of
c the daemon slowly grows; something that was malloc'd isn't being free'd).
c it isn't fixed yet but at least less memory is being lost. also general
c clean-up type of bug fixes.
e
s 00234/00000/00000
d D 1.1 84/04/03 11:29:02 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

%{
# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
# include <netdb.h>
# include <stdio.h>
I 6
# include "aswdaemon.h"
E 6
# include "switch.h"
# include "numlist.h"
# include "symtab.h"
# include "client.h"
# include "clerr.h"

extern int		cfnum;
extern char		cfstr[];
%}

%start	config_file

D 5
%token	CF_NUMBER	/* 01234... */
%token	CF_IDENT	/* identifier */
E 5
I 5
%token	CF_NUMBER	/* 01234...	*/
%token	CF_IDENT	/* identifier	*/
%token	CF_STRING	/* string	*/
E 5

D 5
%token	CF_DISCONNECT	/* "disconnect" */
%token	CF_CONNECT	/* "connect" */
%token	CF_CHANNEL	/* "channel" */
%token	CF_OUTPUT	/* "output" */
%token	CF_INPUT	/* "input" */
%token	CF_RESET	/* "reset" */
%token	CF_FROM		/* "from" */
%token	CF_SET		/* "set" */
%token	CF_USE		/* "use" */
%token	CF_IS		/* "is" */
%token	CF_TO		/* "to" */
%token	CF_EQUAL	/* '=' */
%token	CF_SEMI		/* ';' */
%token	CF_COMMA	/* ',' */
%token	CF_LBRACK	/* '[' */
%token	CF_RBRACK	/* ']' */
E 5
I 5
%token	CF_DISCONNECT	/* "disconnect"	*/
%token	CF_CONNECT	/* "connect"	*/
%token	CF_CHANNEL	/* "channel"	*/
%token	CF_OUTPUT	/* "output"	*/
%token	CF_INPUT	/* "input"	*/
%token	CF_RESET	/* "reset"	*/
I 9
%token	CF_INIT		/* "init"	*/
E 9
%token	CF_FROM		/* "from"	*/
I 10
%token	CF_DUMP		/* "dump"	*/
E 10
%token	CF_SET		/* "set"	*/
%token	CF_USE		/* "use"	*/
%token	CF_IS		/* "is"		*/
%token	CF_TO		/* "to"		*/
%token	CF_EQUAL	/* '='		*/
%token	CF_SEMI		/* ';'		*/
%token	CF_COMMA	/* ','		*/
%token	CF_LBRACK	/* '['		*/
%token	CF_RBRACK	/* ']'		*/
E 5

%type	<num_ty>	num
%type	<num_ty>	type
%type	<numlist_ty>	numlist
%type	<numlist_ty>	chan
%type	<string_ty>	ident
I 5
%type	<string_ty>	string
E 5

%union {
	int			num_ty;
	char			string_ty[BUFSIZ];
	struct numlist *	numlist_ty;
};

%%

config_file:
	file {
D 6
		debug(1, "cfparse: config: file");
E 6
I 6
		debug(DB_PARSE, "cfparse: config: file");
E 6
	};

file:
	file line {
D 6
		debug(1, "cfparse: file: file line");
E 6
I 6
		debug(DB_PARSE, "cfparse: file: file line");
E 6
	} |
	error {
		yyerrok;
		yyclearin;
		client.cl_err = ASW_ERR_SYNTAX;
I 9
		clerrmsg(0);
E 9
D 7
		err(3, "cfparse: file: error");
E 7
I 7
		err(ERR_PARSE, "cfparse: file: error");
E 7
	} |
	/* empty */ {
D 6
		debug(1, "cfparse: file: empty");
E 6
I 6
		debug(DB_PARSE, "cfparse: file: empty");
E 6
	};

line:
D 5
	switch_type {
		debug(1, "cfparse: line: switch_type");
	} |
E 5
	var_assign {
D 6
		debug(1, "cfparse: line: var_assign");
E 6
I 6
		debug(DB_PARSE, "cfparse: line: var_assign");
E 6
	} |
	chan_assign {
D 6
		debug(1, "cfparse: line: chan_assign");
E 6
I 6
		debug(DB_PARSE, "cfparse: line: chan_assign");
E 6
		clerrmsg(1);
	} |
	disconnect {
D 6
		debug(1, "cfparse: line: disconnect");
E 6
I 6
		debug(DB_PARSE, "cfparse: line: disconnect");
E 6
		clerrmsg(1);
	} |
	connect {
D 6
		debug(1, "cfparse: line: connect");
E 6
I 6
		debug(DB_PARSE, "cfparse: line: connect");
E 6
		clerrmsg(1);
	} |
	reset {
D 6
		debug(1, "cfparse: line: reset");
E 6
I 6
		debug(DB_PARSE, "cfparse: line: reset");
E 6
		clerrmsg(1);
I 9
	} |
	init {
		debug(DB_PARSE, "cfparse: line: init");
		clerrmsg(1);
I 10
	} |
	dump {
		debug(DB_PARSE, "cfparse: line: dump");
		clerrmsg(1);
E 10
E 9
	};

D 5
switch_type:
	CF_USE ident CF_SEMI {
		debug(1, "cfparse: switch_type: use ident (%s)", $2);
		info(3, "cfparse: use %s", $2);
		(void) setswitch($2);
	};

E 5
var_assign:
	CF_SET ident CF_EQUAL num CF_SEMI {
I 5
		struct hlist *hl;
E 5
D 6
		debug(1, "cfparse: var_assign: set ident (%s) = num (%d)", $2, $4);
E 6
I 6
		debug(DB_PARSE, "cfparse: var_assign: set ident (%s) = num (%d)", $2, $4);
E 6
D 8
		info(3, "cfparse: set %s = %d", $2, $4);
E 8
I 8
		info(INFO_PARSE, "cfparse: set %s = %d", $2, $4);
E 8
D 5
		(void) cfvarset($2, $4);
E 5
I 5
		if ((hl = lookup($2, ST_NVAR)) == NULL) {
D 7
			err(3, "cfparse: var_assign: can't find var %s", $2);
E 7
I 7
			err(ERR_PARSE, "cfparse: var_assign: can't find var %s", $2);
E 7
			client.cl_err = ASW_ERR_VAR;
		}
		else
			(void) varset(hl, ST_NVAR, $4);
	} |
	CF_SET ident CF_EQUAL string CF_SEMI {
		struct hlist *hl;
D 6
		debug(1, "cfparse: var_assign: set ident (%s) = string (%s)", $2, $4);
E 6
I 6
		debug(DB_PARSE, "cfparse: var_assign: set ident (%s) = string (%s)", $2, $4);
E 6
D 8
		info(3, "cfparse: set %s = %s", $2, $4);
E 8
I 8
		info(INFO_PARSE, "cfparse: set %s = %s", $2, $4);
E 8
		if ((hl = lookup($2, ST_SVAR)) == NULL) {
D 7
			err(3, "cfparse: var_assign: can't find var %s", $2);
E 7
I 7
			err(ERR_PARSE, "cfparse: var_assign: can't find var %s", $2);
E 7
			client.cl_err = ASW_ERR_VAR;
		}
		else
			(void) varset(hl, ST_SVAR, $4);
E 5
	};

chan_assign:
	CF_OUTPUT ident CF_IS numlist CF_SEMI {
D 2
		$4->nl_type = NL_OUTPUT;
E 2
I 2
		typenl($4, NL_OUTPUT);
E 2
D 6
		debug(1, "cfparse: chan_assign: output ident (%s) is numlist (%s)", $2, prnumlist($4));
E 6
I 6
		debug(DB_PARSE, "cfparse: chan_assign: output ident (%s) is numlist (%s)", $2, prnumlist($4));
E 6
D 8
		info(3, "cfparse: output %s is %s", $2, prnumlist($4));
E 8
I 8
		info(INFO_PARSE, "cfparse: output %s is %s", $2, prnumlist($4));
E 8
		(void) install($2, ST_NL_OUTPUT, (char *) $4);
	} |
	CF_INPUT ident CF_IS numlist CF_SEMI {
D 2
		$4->nl_type = NL_INPUT;
E 2
I 2
		typenl($4, NL_INPUT);
E 2
D 6
		debug(1, "cfparse: chan_assign: input ident (%s) is numlist (%s)", $2, prnumlist($4));
E 6
I 6
		debug(DB_PARSE, "cfparse: chan_assign: input ident (%s) is numlist (%s)", $2, prnumlist($4));
E 6
D 8
		info(3, "cfparse: input %s is %s", $2, prnumlist($4));
E 8
I 8
		info(INFO_PARSE, "cfparse: input %s is %s", $2, prnumlist($4));
E 8
		(void) install($2, ST_NL_INPUT, (char *) $4);
	};

disconnect:
	CF_DISCONNECT chan CF_FROM chan CF_SEMI {
D 6
		debug(1, "cfparse: disconnect: disconnect chan (%s) from chan (%s)", prnumlist($2), prnumlist($4));
E 6
I 6
		debug(DB_PARSE, "cfparse: disconnect: disconnect chan (%s) from chan (%s)", prnumlist($2), prnumlist($4));
E 6
D 8
		info(2, "cfparse: disconnect %s from %s", prnumlist($2), prnumlist($4));
E 8
I 8
		info(INFO_PARSE, "cfparse: disconnect %s from %s", prnumlist($2), prnumlist($4));
E 8
		if (($2 != NULL) && ($4 != NULL))
			(void) (*sw->sw_disconn)($2, $4);
I 2

		if ($2 != NULL)
			freenl($2);
		if ($4 != NULL)
			freenl($4);
E 2
	} |
	CF_DISCONNECT chan CF_SEMI {
D 6
		debug(1, "cfparse: disconnect: disconnect chan (%s)", prnumlist($2));
E 6
I 6
		debug(DB_PARSE, "cfparse: disconnect: disconnect chan (%s)", prnumlist($2));
E 6
D 8
		info(2, "cfparse: disconnect %s", prnumlist($2));
E 8
I 8
		info(INFO_PARSE, "cfparse: disconnect %s", prnumlist($2));
E 8
D 2
		if ($2 != NULL)
E 2
I 2
		if ($2 != NULL) {
E 2
			(void) (*sw->sw_disconn)($2, NULL);
I 2
			freenl($2);
		}
E 2
	};

connect:
	CF_CONNECT chan CF_TO chan CF_SEMI {
D 6
		debug(1, "cfparse: connect: connect chan (%s) to chan (%s)", prnumlist($2), prnumlist($4));
E 6
I 6
		debug(DB_PARSE, "cfparse: connect: connect chan (%s) to chan (%s)", prnumlist($2), prnumlist($4));
E 6
D 8
		info(2, "cfparse: connect %s to %s", prnumlist($2), prnumlist($4));
E 8
I 8
		info(INFO_PARSE, "cfparse: connect %s to %s", prnumlist($2), prnumlist($4));
E 8
		if (($2 != NULL) && ($4 != NULL))
			(void) (*sw->sw_conn)($2, $4);
I 2

		if ($2 != NULL)
			freenl($2);
		if ($4 != NULL)
			freenl($4);
I 9
	};

init:
	CF_INIT CF_SEMI {
		info(INFO_PARSE, "cfparse: init");
		client.cl_err = ASW_ERR_INIT;
		/* (void) reconf(); */
I 10
	};

dump:
	CF_DUMP CF_SEMI {
		extern char	*prconnlist();
		static char	*connlist;

		info(INFO_PARSE, "cfparse: dump");
		if (strlen(connlist = prconnlist()))
			err(ERR_PARSE, "cfparse: dump: %s", connlist);
		else
			err(ERR_PARSE, "cfparse: dump: empty connlist");
E 10
E 9
E 2
	};

reset:
	CF_RESET CF_SEMI {
D 8
		info(2, "cfparse: reset");
E 8
I 8
		info(INFO_PARSE, "cfparse: reset");
E 8
		(void) (*sw->sw_reset)();
	};

chan:
	type ident {
		struct hlist *hl;

D 6
		debug(1, "cfparse: chan: ident (%s)", $2);
E 6
I 6
		debug(DB_PARSE, "cfparse: chan: ident (%s)", $2);
E 6
		if ((hl = lookup($2, $1)) == NULL) {
D 4
			err(3, "cfparse: chan: can't find ident %s", $2);
			client.cl_err = ASW_ERR_CHAN;
E 4
I 4
D 7
			err(3, "cfparse: chan: can't find symbolic chan %s", $2);
E 7
I 7
			err(ERR_PARSE, "cfparse: chan: can't find symbolic chan %s", $2);
E 7
			client.cl_err = ASW_ERR_SYMCHAN;
E 4
			$$ = NULL;
		}
		else {
D 2
			$$ = hl->hl_numlist;
E 2
I 2
# ifdef notdef
I 3
			/*
			 * shouldn't be necessary since
			 * the type was set already by
			 * the input/output command.
			 */
E 3
E 2
			if ($1 == ST_NL_INPUT)
D 2
				typenl($$, NL_INPUT);
E 2
I 2
				typenl(hl->hl_numlist, NL_INPUT);
			else if ($1 == ST_NL_OUTPUT)
				typenl(hl->hl_numlist, NL_OUTPUT);
E 2
			else
D 2
				typenl($$, NL_OUTPUT);
E 2
I 2
				typenl(hl->hl_numlist, -1); /* can't happen */
# endif notdef

			$$ = savenl(hl->hl_numlist);
E 2
		}
	} |
	type ident CF_LBRACK numlist CF_RBRACK {
		struct numlist *nl;
		struct hlist *hl;

D 6
		debug(1, "cfparse: ident (%s) [ numlist (%s) ]", $2, prnumlist($4));
E 6
I 6
		debug(DB_PARSE, "cfparse: ident (%s) [ numlist (%s) ]", $2, prnumlist($4));
E 6
		if ((hl = lookup($2, $1)) == NULL) {
D 7
			err(3, "cfparse: chan: can't find ident %s", $1);
E 7
I 7
			err(ERR_PARSE, "cfparse: chan: can't find ident %s", $1);
E 7
			client.cl_err = ASW_ERR_CHAN;
			$$ = NULL;
		}
		else if ((nl = subnl(hl->hl_numlist, $4)) == NULL) {
D 7
			err(2, "cfparse: chan: can't get sublist", $1);
E 7
I 7
			err(ERR_PARSE, "cfparse: chan: can't get sublist", $1);
E 7
			client.cl_err = ASW_ERR_SUBL;
			$$ = NULL;
		}
		else {
D 2
			$$ = nl;
E 2
I 2
# ifdef notdef
I 3
			/*
			 * shouldn't be necessary since
			 * the type was set already by
			 * the input/output command.
			 */
E 3
E 2
			if ($1 == ST_NL_INPUT)
D 2
				typenl($$, NL_INPUT);
E 2
I 2
				typenl(nl, NL_INPUT);
			else if ($1 == ST_NL_OUTPUT)
				typenl(nl, NL_OUTPUT);
E 2
			else
D 2
				typenl($$, NL_OUTPUT);
E 2
I 2
				typenl(nl, -1);	/* can't happen */
# endif notdef

			$$ = nl;	/* will get freenl'd later */
E 2
		}
I 2

		freenl($4);
E 2
	} |
	type numlist {
D 6
		debug(1, "cfparse: numlist (%s)", prnumlist($2));
E 6
I 6
		debug(DB_PARSE, "cfparse: numlist (%s)", prnumlist($2));
E 6
D 2
		$$ = $2;
E 2
I 2
D 3
# ifdef notdef
E 3
I 3

		/*
		 * have to set the type because it isn't
		 * known since this is just a naked number
		 * list.
		 */
E 3
E 2
		if ($1 == ST_NL_INPUT)
D 2
			typenl($$, NL_INPUT);
E 2
I 2
			typenl($2, NL_INPUT);
		else if ($1 == ST_NL_OUTPUT)
			typenl($2, NL_OUTPUT);
E 2
		else
D 2
			typenl($$, NL_OUTPUT);
E 2
I 2
			typenl($2, -1);	/* can't happen */
D 3
# endif notdef
E 3

		$$ = $2;	/* will get freenl'd later */
E 2
	};

type:
	CF_INPUT {
D 6
		debug(1, "cfparse: type: input");
E 6
I 6
		debug(DB_PARSE, "cfparse: type: input");
E 6
		$$ = ST_NL_INPUT;
	} |
	CF_OUTPUT {
D 6
		debug(1, "cfparse: type: output");
E 6
I 6
		debug(DB_PARSE, "cfparse: type: output");
E 6
		$$ = ST_NL_OUTPUT;
	};

numlist:
	num {
D 6
		debug(1, "cfparse: numlist: num (%d)", $1);
E 6
I 6
		debug(DB_PARSE, "cfparse: numlist: num (%d)", $1);
E 6
		$$ = maknl($1, -1);	/* don't know type so use -1 for now */
	} |
	numlist CF_COMMA num {
D 6
		debug(1, "cfparse: numlist: numlist (%s), num (%d)", prnumlist($1), $3);
E 6
I 6
		debug(DB_PARSE, "cfparse: numlist: numlist (%s), num (%d)", prnumlist($1), $3);
E 6
I 2
		/* addnl appends $3 onto $1 then returns $1 */
E 2
		$$ = addnl($1, $3);
	};

num:
	CF_NUMBER {
D 6
		debug(1, "cfparse: num: %d", cfnum);
E 6
I 6
		debug(DB_PARSE, "cfparse: num: %d", cfnum);
E 6
		$$ = cfnum;
	};

ident:
	CF_IDENT {
D 6
		debug(1, "cfparse: ident: %s", cfstr);
E 6
I 6
		debug(DB_PARSE, "cfparse: ident: %s", cfstr);
E 6
I 5
		strcpy($$, cfstr);
	};

string:
	CF_STRING {
D 6
		debug(1, "cfparse: string: %s", cfstr);
E 6
I 6
		debug(DB_PARSE, "cfparse: string: %s", cfstr);
E 6
E 5
		strcpy($$, cfstr);
	};
E 1
