h30820
s 00004/00004/00108
d D 1.7 85/04/16 23:52:27 rusty 7 6
c code for setting up socket address should be more correct now
e
s 00020/00020/00092
d D 1.6 84/11/18 15:10:08 rusty 6 5
c added some configuration variables to the config file instead of using #ifdef's in the code
e
s 00013/00000/00099
d D 1.5 84/11/18 14:41:13 rusty 5 4
c added #ifdef LOCALONLY; if defined then socket connections are allowed when on the local net only
e
s 00003/00003/00096
d D 1.4 84/07/24 13:41:39 rusty 4 3
c changed info messages to use bits in ilevel instead of ranges of values
e
s 00005/00005/00094
d D 1.3 84/07/24 13:01:39 rusty 3 2
c changed error messages to use bits in elevel instead of ranges of values
e
s 00014/00006/00085
d D 1.2 84/04/26 10:54:50 rusty 2 1
c if the bind() fails on the socket then use the host "localhost" instead of
c "aswhost". this helps when the network (or its interface) is down.
e
s 00091/00000/00000
d D 1.1 84/04/25 15:52:45 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
I 7
# include <arpa/inet.h>
E 7
# include <netdb.h>
# include <stdio.h>
# include "switch.h"
# include "aswdaemon.h"

# define DEBUGPORT	2345

/*
 * aswsock
 *
 * aswsock sets up the master socket that clients
 * connect to when requesting a service.
 *
 * we use the internet address format (AF_INET) and
 * the stream type (SOCK_STREAM).
 *
 * the aswdaemon is expected to be run on the host
 * hostnam (e.g. "aswhost") and have its port number
 * in the file /etc/services.
 */
aswsock() {
	register struct servent *sp;
	register struct hostent *hp;
	struct sockaddr_in sin;
	char buf[BUFSIZ];

D 2
	bzero((char *) &sin, sizeof(sin));
E 2
I 2
retry:	bzero((char *) &sin, sizeof(sin));
E 2

	/*
I 5
D 6
	 * if LOCALONLY is defined then connections are
E 6
I 6
	 * if lconn is non-zero then connections are
E 6
	 * restricted to machines that are only on the
	 * network given in hp->h_addr. otherwise any
D 7
	 * machine on any network can connect to the
	 * daemon (via routing).
E 7
I 7
	 * machine can connect to the daemon.
E 7
	 */
I 6
	if (lconn) {
		/*
		 * get the family and address of the host
		 * that the asw daemon runs on from the
		 * /etc/hosts file.
		 */
		if ((hp = gethostbyname(hostnam)) == NULL) {
			err(ERR_IPC, "aswsock: no such host: %s", hostnam);
			if (strcmp(hostnam, lhostnam) == 0)
				return(RET_ERR);
E 6

D 6
# ifdef LOCALONLY
	/*
E 5
	 * get the family and address of the host
	 * that the asw daemon runs on from the
	 * /etc/hosts file.
	 */
	if ((hp = gethostbyname(hostnam)) == NULL) {
D 3
		err(1, "aswsock: no such host: %s", hostnam);
E 3
I 3
		err(ERR_IPC, "aswsock: no such host: %s", hostnam);
E 3
D 2
		info(1, "aswsock: using host %s", lhostnam);
		if ((hp = gethostbyname(lhostnam)) == NULL) {
			err(1, "aswsock: no such host: %s", lhostnam);
E 2
I 2
		if (strcmp(hostnam, lhostnam) == 0)
E 2
			return(RET_ERR);
D 2
		}
E 2
I 2

		strcpy(hostnam, lhostnam);
		goto retry;
E 6
I 6
			strcpy(hostnam, lhostnam);
			goto retry;
		}
		sin.sin_family = hp->h_addrtype;
D 7
		bcopy(hp->h_addr, (caddr_t) &sin.sin_addr, hp->h_length);
E 7
I 7
		sin.sin_addr = inet_makeaddr(inet_netof(*(struct in_addr *) hp->h_addr), INADDR_ANY);
E 7
E 6
E 2
	}
D 6
	sin.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr, (caddr_t) &sin.sin_addr, hp->h_length);
I 5
# else LOCALONLY
	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_ANY;
# endif LOCALONLY
E 6
I 6
	else {
		sin.sin_family = AF_INET;
D 7
		sin.sin_addr.s_addr = INADDR_ANY;
E 7
I 7
		sin.sin_addr = inet_makeaddr(0, INADDR_ANY);
E 7
	}
E 6
E 5

	/*
	 * get the port number of the asw daemon from the /etc/services
	 * file. default service is "aswdaemon". if there is more than
	 * one daemon then the name of the service is constructed by
	 * appending the service type to the string "aswdaemon-". for
	 * example at CARL we use the type "ss" so we could put the
	 * service name "aswdaemon-ss" in /etc/services.
	 */
	sprintf(buf, "aswdaemon");
	if ((sp = getservbyname(buf, sw->sw_proto)) == NULL) {
D 4
		info(1, "aswsock: no such service: %s", buf);
E 4
I 4
		info(INFO_IPC, "aswsock: no such service: %s", buf);
E 4
		sprintf(buf, "aswdaemon-%s", sw->sw_type);
		if ((sp = getservbyname(buf, sw->sw_proto)) == NULL) {
D 3
			err(1, "aswsock: no such service: %s/%s", buf, sw->sw_proto);
E 3
I 3
			err(ERR_IPC, "aswsock: no such service: %s/%s", buf, sw->sw_proto);
E 3
			return(RET_ERR);
		}
	}

	sin.sin_port = sp->s_port;

	if (debug_mode) {
D 4
		info(1, "aswsock: using port %d", DEBUGPORT);
E 4
I 4
		info(INFO_IPC, "aswsock: using port %d", DEBUGPORT);
E 4
		sin.sin_port = htons(DEBUGPORT);
	}

	if ((sock = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
D 3
		err(1, "aswsock: socket: %m");
E 3
I 3
		err(ERR_IPC, "aswsock: socket: %m");
E 3
		return(RET_ERR);
	}

	if (bind(sock, (struct sockaddr *) &sin, sizeof(sin)) == -1) {
D 3
		err(1, "aswsock: bind: %m");
E 3
I 3
		err(ERR_IPC, "aswsock: bind: %m");
E 3
D 2
		return(RET_ERR);
E 2
I 2
		if (strcmp(hostnam, lhostnam) == 0)
			return(RET_ERR);

		/*
		 * klunky, but it helps when the net is down
		 */
D 4
		info(1, "aswsock: trying host %s", lhostnam);
E 4
I 4
		info(INFO_IPC, "aswsock: trying host %s", lhostnam);
E 4
		strcpy(hostnam, lhostnam);
		goto retry;
E 2
	}

	if (listen(sock, NCLIENTS) == -1) {
D 3
		err(1, "aswsock: listen: %m");
E 3
I 3
		err(ERR_IPC, "aswsock: listen: %m");
E 3
		return(RET_ERR);
	}

	return(RET_OK);
}
E 1
