/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/param.h>
# include <grp.h>
# include <stdio.h>

static char	buf[BUFSIZ];

main(argc, argv)
	char	**argv;
{
	extern char	*disconnasw();
	extern char	*strsave();
	extern char	*connasw();
	extern char	*sendasw();
	char		*msg;
	char		*pv;
	char		resasw;
	int		i, j;

	for (i = 1; i < argc; i++) {
		pv = argv[i];
		if (pv[0] != '-') {
			usage();
			break;
		}
		for (j = 1; pv[j] != NULL; j++) {
			switch (pv[j]) {
				/* raw mode */
				case 'R':
					if (pv[j+1] == NULL)
						err("-R needs arg");
					else {
						if ((msg = sendasw(&pv[j+1])) != NULL)
							err(msg);
					}
					goto contin;

				/* connect */
				case 'c':
					if (pv[j+1] == NULL)
						err("-c needs arg");
					else {
						if ((msg = connasw(&pv[j+1], NULL)) != NULL)
							err(msg);
					}
					goto contin;

				/* disconnect */
				case 'd':
					if ((msg = disconnasw()) != NULL)
						err(msg);
					goto contin;

				/* init */
				case 'i':
					initasw();
					break;

				/* reset */
				case 'r':
					if (okgrp())
						resetasw();
					break;

				/* help */
				case 'h':
					help();
					break;

				/* oops */
				default:
					usage();
					break;
			}
		}
		contin:;
	}

	if (i == 1)
		usage();

	exit(0);
}

help() {
	fprintf(stderr, "asw: usage: asw [-coutput_device] [-d] [-r] [-Rstring\n");
	fprintf(stderr, "-c connects your input space to \"output_device\"\n");
	fprintf(stderr, "-d disconnects your input space to any output devices\n");
	fprintf(stderr, "-i initializes the asw daemon (causes it to re-read the config file)\n");
	fprintf(stderr, "-r resets the asw daemon; disconnects all input spaces from all output devices\n");
	fprintf(stderr, "-R sends the string ``as is'' to the asw daemon\n");
}

usage() {
	fprintf(stderr, "asw: usage: asw [-cdacs] [-d] [-r]\n");
	exit(1);
}

err(msg)
	char *msg;
{
	fprintf(stderr, "%s\n", msg);
	exit(1);
}

char *
strsave(str)
register char *str;
{
	extern char *malloc();
	register char *chp;

	if ((chp = malloc(strlen(str)+1)) == NULL)
		return(NULL);

	strcpy(chp, str);

	return(chp);
}

char *
sendasw(msg)
	char	*msg;
{
	int	len;
	int	fd;

	fprintf(stderr, "sending \"%s\"\n", msg);

	if ((fd = openasw()) == -1)
		return("can't connect to asw daemon");

	len = strlen(msg);
	if (write(fd, msg, len) != len) {
		closeasw(fd);
		return("write to asw daemon failed");
	}
	if (write(fd, "\n", 1) != 1) {
		closeasw(fd);
		return("write (newline) to asw daemon failed");
	}

	if ((len = read(fd, buf, sizeof(buf))) > 0) {
		closeasw(fd);
		buf[len] = NULL;
		if (strcmp(buf, "ok") != 0) {
			closeasw(fd);
			return(buf);
		}
	}

	closeasw(fd);

	return(NULL);
}

okgrp() {
# ifdef notdef
	extern struct group	*getgrnam();
	struct group		*gr;
	int			groups[NGROUPS];
	int			ngroups;

	if (getgroups(&ngroups, groups) == -1) {
		fprintf(stderr, "asw: ");
		perror("getgroups");
		return(0);
	}

	if ((gr = getgrnam("sys")) == NULL)
		return(0);

	while (--ngroups >= 0) {
		if (groups[ngroups] == gr->gr_gid)
			return(1);
	}

	fprintf(stderr, "not priviledged enough for that\n");
	return(0);
# else notdef
	if (geteuid() != 0) {
		fprintf(stderr, "not priviledged enough for that\n");
		return(0);
	}

	return(1);
# endif notdef
}
