h31082
s 00038/00018/00059
d D 1.2 86/09/17 23:18:41 rusty 2 1
c 
e
s 00077/00000/00000
d D 1.1 84/04/25 16:15:21 rusty 1 0
c original distributed version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <sys/types.h>
# include <sys/socket.h>
# include <netinet/in.h>
I 2
# include <arpa/inet.h>
E 2
# include <netdb.h>
# include <errno.h>
# include <stdio.h>

static int aswfd =		-1;		/* fd for socket */

D 2
static char servname[] =	"aswdaemon";
static char aswhost[] =		"aswhost";
E 2
I 2
static char hostnam[BUFSIZ] =	"aswhost";
static char althostnam[] =	"localhost";
static char servnam[] =		"asw";
E 2
static char servproto[] =	"tcp";

/*
 * OPENASW -- connect to asw daemon
 */
openasw() {
	extern int errno;
	struct sockaddr_in aswaddr;
	register struct servent *sp;
	register struct hostent *hp;
	register int i;

	if (aswfd >= 0)
		return(aswfd);

D 2
	bzero((char *) &aswaddr, sizeof(aswaddr));
E 2
I 2
retry:	bzero((char *) &aswaddr, sizeof(aswaddr));
E 2

D 2
	if ((hp = gethostbyname(aswhost)) == NULL) {
		fprintf(stderr, "openasw: no such host %s\n", aswhost);
E 2
I 2
	if ((hp = gethostbyname(hostnam)) == NULL) {
		fprintf(stderr, "openasw: no such host %s\n", hostnam);
E 2
		return(-1);
	}
D 2
	aswaddr.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr, (char *) &aswaddr.sin_addr, hp->h_length);
E 2

D 2
	if ((sp = getservbyname(servname, servproto)) == NULL) {
		fprintf(stderr, "openasw: no such service %s/%s\n", servname, servproto);
E 2
I 2
	if ((sp = getservbyname(servnam, servproto)) == NULL) {
		fprintf(stderr, "openasw: no such service %s/%s\n", hostnam, servproto);
E 2
		return(-1);
	}
I 2

E 2
	aswaddr.sin_port = sp->s_port;
I 2
	aswaddr.sin_family = hp->h_addrtype;
	bcopy(hp->h_addr, (char *) &aswaddr.sin_addr, hp->h_length);
	/*aswaddr.sin_addr = *(struct in_addr *) hp->h_addr;*/
E 2

	if ((aswfd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
		perror("openasw: socket");
		return(-1);
	}

	for (i = 0; i < 16; i++) {
D 2
		if (connect(aswfd, (char *) &aswaddr, sizeof(aswaddr)) != -1)
			break;
E 2
I 2
		if (connect(aswfd, (char *) &aswaddr, sizeof(aswaddr)) == -1) {
			if (errno == ECONNREFUSED) {
				sleep(1);
				continue;
			}
			else if ((errno == EADDRNOTAVAIL) || (errno == ENETUNREACH)) {
				if (strcmp(hostnam, althostnam) == 0) {
					perror("openasw: connect");
					return(-1);
				}
E 2

D 2
		if (errno == ECONNREFUSED) {
			sleep(1);
			continue;
E 2
I 2
				/*
				 * klunky, but it works...
				 */
				fprintf(stderr, "openasw: connect to host \"%s\" failed, trying host \"%s\"...\n", hostnam, althostnam);
				strcpy(hostnam, althostnam);
				(void) shutdown(aswfd, 2);
				(void) close(aswfd);
				goto retry;
			}
			else {
				perror("openasw: connect");
				return(-1);
			}
E 2
		}
D 2
		else {
			perror("openasw: connect");
			return(-1);
		}
E 2
I 2
		else
			break;
E 2
	}

	return(aswfd);
}

/*
 * CLOSEASW -- close asw daemon socket
 */
closeasw(fd) {
	if (fd != aswfd)
		return(-1);

	(void) close(aswfd);
	aswfd = -1;

	return(0);
}
E 1
