h64976
s 00097/00000/00000
d D 1.1 84/12/21 11:47:58 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <carl/carl.h>
# include <sys/file.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>

u_char	cmds[] = {
	0xff,		/* reset */
	0xec,		/* active track */
	0x01,		/* track 0 */
	0xb8 		/* clear play */
};

main(argc, argv) 
	char **argv;
{
	u_char	buf[BUFSIZ];
	int	ffd, fd, track, n, cnt = 2, ch;

	while ((ch = crack(argc, argv, "r|h", 0)) != '\0') {
		switch (ch) {
			case 'r':
				cnt = sfexpr(arg_option, 1.0);
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}

	/* open the first file on the command line */
	if (argc > arg_index) {
		if ((ffd = open(argv[arg_index], 0)) < 0) {
			fprintf(stderr, "%s ", argv[1]);
			perror("open");
			exit(1);
		}
	} else
		usage(1);

	if ((fd = open("/dev/mpu0", 2)) == -1)
		exit(2);

	/* initialize mpu */
	if (write(fd, cmds, sizeof(cmds)) != sizeof(cmds))
		exit(3);

	/* tell the driver to send data to track 0 */
	track = 0;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(4);
	/* send first buffer */
	if ((n = read(ffd, buf, BUFSIZ)) > 0)
		if (write(fd, buf, n) != n)
			exit(5);

	/* turn on mpu */
	track = MPU_TR_COM;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(6);
	buf[0] = 0x0a;
	if (write(fd, buf, sizeof(u_char)) != sizeof(u_char))
		exit(7);

	/* send the rest of the data */
	track = 0;
	if (ioctl(fd, MPU_IOC_TRACK, &track) == -1)
		exit(4);
	while ((n = read(ffd, buf, BUFSIZ)) > 0)
		if (write(fd, buf, n) != n)
			exit(5);

	while (--cnt) {
		/* start over */
		if (lseek(ffd, 0L, L_SET) < 0) {
			perror("lseek");
			exit(1);
		}
		while ((n = read(ffd, buf, BUFSIZ)) > 0) {
			if (write(fd, buf, n) != n)
				exit(5);
		}
	}

	close(ffd);
	close(fd);
	exit(0);
}

usage(ex)
	int ex;
{
}
E 1
