h63116
s 00015/00003/00342
d D 1.2 85/02/21 16:59:15 dgl 2 1
c added timebase flag
e
s 00345/00000/00000
d D 1.1 84/12/21 11:41:47 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <signal.h>
# include <sys/file.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>
# include <carl/carl.h>
# include <sys/types.h>
# include <carl/midi.h>
# include <carl/mpu.h>

# define DX7_RESET

# define UCH(ch)	((unsigned char) ch)

static char		mpu[] = MPU_DEV_0;
static char		tty[] = "/dev/tty";

/* UCH(0x2a)	/* start overdub	*/
# define SET_TRACK(x) 	tracks |= (1 << (x))


u_char		reset = RT_RESET;
u_char		mpu_cmds[BUFSIZ];
int		mpu_fd;

main(argc, argv) 
	char **argv;
{
	extern int mpu_purge();
	char 		 buf[BUFSIZ], 
			*cmd_file = NULL, 
			*char_op; 
	u_char		 ch,
			 tracks = 0;
	register int	 i;
	int		 mpu_rfd, 
			 mpu_wfd, 
			 tty_fd = -1, 
			 otty = isatty(1), 
			 option,
			 setup_len = 0,
			 file_fd[MPU_TR_MAX],
			 n, 
			 ioc_arg, 
			 pfiles, 
			 trk = 0, 
			 fd_ind,
			 ret_wait = 1,
			 rew[MPU_TR_MAX];

	for (i = 0; i < MPU_TR_MAX; i++) {
		file_fd[i] = -1;
		rew[i] = 0;
	}

# ifdef DX7_RESET
	dx7_clear(mpu_cmds);
# else
	setup_cmds(mpu_cmds, UCH(0xff));	/* reset 		*/
# endif DX7_RESET

D 2
	while ((ch = crack(argc, argv, "c|mMB|t|hwr|", 0)) != '\0') {
E 2
I 2
	while ((ch = crack(argc, argv, "c|mMb|B|t|hwr|", 0)) != '\0') {
E 2
		switch (ch) {
			case 'w':
				ret_wait = 0;
				break;
			case 'c':
				cmd_file = arg_option;
				break;
			case 'm':
				setup_cmds(mpu_cmds, MPU_METRO_NO_ACC);
				break;
			case 'M':
				setup_cmds(mpu_cmds, MPU_METRO_ACC);
				break;
D 2
			case 'B':
E 2
I 2
			case 'b':
E 2
				setup_cmds(mpu_cmds, MPU_METRO_MEAS);
				ch = sfexpr(arg_option, 1.0);
				setup_cmds(mpu_cmds, ch);
				break;
I 2
			case 'B':
				{
				register int tmp = sfexpr(arg_option, 1.0);
				if (tmp < 48 || tmp > 192) {
					fprintf(stderr, "illegal timebase\n");
					exit(1);
				}
				tmp = (tmp - 48) / 24;
				(void) setup_cmds(mpu_cmds, tmp + 0xc2);
				break;
				}
E 2
			case 't':
				setup_cmds(mpu_cmds, MPU_TEMPO);
				ch = sfexpr(arg_option, 1.0);
				setup_cmds(mpu_cmds, ch);
				break;
			case 'r':
				rew[0] = sfexpr(arg_option, 1.0);
				for (i = 0; i < MPU_TR_MAX; i++)
					rew[i] = rew[0];
				break;
			case 'h':
				usage(0);
			default:
				usage(1);
		}
	}

	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
		signal(SIGINT, mpu_purge);

	if ((mpu_fd = mpu_rfd = mpu_wfd = open(mpu, 2)) == -1) {
		fprintf(stderr, "open: ");
		perror(mpu);
		exit(1);
	}

	if (ret_wait) {
		if ((tty_fd = open(tty, 2)) == -1) {
			fprintf(stderr, "open: ");
			perror(tty);
			exit(1);
		}
	}

	/* open up play files */
	pfiles = argc - arg_index;
	if (pfiles > MPU_TR_MAX) {
		fprintf(stderr, "too many tracks, limit == %d\n", MPU_TR_MAX);
		usage(1);
	}
	for (i = arg_index; i < argc; i++) {
		if ((file_fd[i-arg_index] = open(argv[i], 0)) == -1) {
			fprintf(stderr, "open: ");
			perror(argv[i]);
			exit(1);
		}
		tracks |= (1 << (i - arg_index));
		/* SET_TRACK(i - arg_index); */
	}

	setup_cmds(mpu_cmds, UCH(0xec));	/* active track 	*/
	setup_cmds(mpu_cmds, tracks);	/* track #'s		*/
	setup_cmds(mpu_cmds, UCH(0xb8));	/* clear play		*/
	setup_cmds(mpu_cmds, UCH(0x87));	/* bender on		*/

	/* what kind of operation? */
	if (otty == 0 && pfiles <= 0) {		/* record */
		setup_len = setup_cmds(mpu_cmds, 0x22);
		mpu_wfd = 0;			/* don't select on write */
		char_op = "record";
	} else if (otty != 0 && pfiles > 0) {	/* playback */
		setup_len = setup_cmds(mpu_cmds, 0x0a);
		mpu_rfd = 0;			/* don't select on read */
		char_op = "playback";
	} else if (otty == 0 && pfiles > 0) {	/* overdub */
		setup_len = setup_cmds(mpu_cmds, 0x2a);
		char_op = "overdub";
	} else if (otty != 0 && pfiles <= 0) 	/* error */
		usage(1);

	if (ret_wait) {
		fprintf(stderr, "Press [RETURN] to %s\t", char_op);
		fflush(stderr);
		if (iwait(tty_fd, 3600L) == 0) {
			fprintf(stderr, "timeout, aborting.\n");
			exit(1);
		} else
			read(tty_fd, &ch, 1);
	}

	if (pfiles > 0) {
		/* tell mpu to expect track data */
		ioc_arg = 0;
		if (ioctl(mpu_fd, MPU_IOC_TRACK, &ioc_arg) == -1) {
			fprintf(stderr, "MPU_IOC_TRACK1\t");
			perror("ioctl");
			exit(1);
		}

		/* pre-fill one block for each playback buffer */
		for (i = 0; i < pfiles; i++) {
			register int n;
			/* tell mpu to expect track data */
			ioc_arg = i;
			if (ioctl(mpu_fd, MPU_IOC_TRACK, &ioc_arg) == -1) {
				fprintf(stderr, "MPU_IOC_TRACK2\t");
				perror("ioctl");
				exit(1);
			}
			/* pre-write first midi buffer */
			if ((n = read(file_fd[i], buf, BUFSIZ)) > 0) {
				if (write(mpu_fd, buf, n) != n) {
					perror("write");
					exit(1);
				}
			}
		}
	}

	/* tell mpu to expect command data */
	ioc_arg = MPU_TR_COM;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &ioc_arg) == -1) {
		fprintf(stderr, "MPU_IOC_TRACK3\t");
		perror("ioctl");
		exit(1);
	}
	/* user specified command file? */
	if (cmd_file != NULL) {
		FILE *cmd_fid;
		u_char str_buf[BUFSIZ], cmd_buf[BUFSIZ];
		int i = 0;

		if ((cmd_fid = fopen(cmd_file, "r")) == NULL) {
			perror("fopen");
			exit(1);
		}
		while (fscanf(cmd_fid, "%s", str_buf) == 1) {
			cmd_buf[i] = sfexpr(str_buf, 1.0);
			fprintf(stderr, "0x%x\n", cmd_buf[i]);
			i++;
		}
		fclose(cmd_fid);
		if (write(mpu_fd, cmd_buf, i) != i) {
			perror("write");
			exit(1);
		}
	} else {	
		/* write default command sequence */
		if (write(mpu_fd, mpu_cmds, setup_len) 
		    != setup_len) {
			perror("write");
			exit(1);
		}
	}

	while ((fd_ind = trw_sel(tty_fd, mpu_rfd, mpu_wfd, 360L)) > 0) {
		if (fd_ind == TRW_SEL_TTY) {
			read(tty_fd, &ch, 1);
			mpu_purge();
			break;
		} else if (fd_ind == TRW_SEL_RFD) {
			if ((n = read(mpu_fd, buf, 1)) > 0) {
				if (otty) {
					for (i = 0; i < n; i++)
						printf("0x%02x\n", buf[i]);
				}
				else {
					if (write(1, buf, n) != n) {
						perror("write");
						break;
					}
				}
			}
			else {
				perror("read");
				break;
			}
		} else if (fd_ind == TRW_SEL_WFD) {
			if ((trk = pick_fd(mpu_fd, file_fd, pfiles)) == -1) {
				mpu_wfd = -1;
				continue;
			}
			if ((n = read(file_fd[trk], buf, BUFSIZ)) > 0) {
				/* tell mpu to expect track data */
				if (ioctl(mpu_fd, MPU_IOC_TRACK, 
				    &trk) == -1) {
					fprintf(stderr, "MPU_IOC_TRACK4\t");
					perror("ioctl");
					exit(1);
				}
				if (write(mpu_fd, buf, n) != n) {
					perror("write");
					exit(1);
				}
			} else {
				if (--rew[trk] > 0)
					lseek(file_fd[trk], 0L, L_SET);
				else {
					close(file_fd[trk]);
					file_fd[trk] = -1;
				}
			}
		} else {
			fprintf(stderr, "mpuoverdub: trw_sel failed\n");
			exit(1);
		}
	}

	/* fprintf(stderr, "finishing.\n"); */
	close(mpu_fd);
	dx7_reset(-1);
	if (ret_wait)
		close(tty_fd);
}

mpu_purge(sig)
{
	if (ioctl(mpu_fd, MPU_IOC_PURGE, 0) == -1) {
		fprintf(stderr, "MPU_IOC_PURGE\t");
		fprintf(stderr, "ioctl: ");
		perror(mpu);
		exit(1);
	}
}

/*
 * pick_fd -	return index of fd with smallest residue buffered in driver
 * 		return -1 when no fd is left to pick
 */

pick_fd(mpu_fd, file_fd, pfiles)
	int 	mpu_fd,
		file_fd[],
		pfiles;
{
	int 		i, 
			min_resid = 0x3fffffff,
			ind_min_resid = -1;
	mpu_resid	resid;

	if (ioctl(mpu_fd, MPU_IOC_RESID, &resid) == -1) {
		fprintf(stderr, "MPU_IOC_RESID\t");
		fprintf(stderr, "ioctl: ");
		perror(mpu);
		exit(1);
	}

	for (i = 0; i < MPU_TR_MAX; i++) {
		if (file_fd[i] != -1) {
			if (resid.mr_tresid[i] < min_resid) {
				min_resid = resid.mr_tresid[i];
				ind_min_resid = i;
			}
		}
	}
	return(ind_min_resid);
}

usage(ex)
{
D 2
fprintf(stderr, "%s%s%s%s%s%s%s%s%s",
E 2
I 2
fprintf(stderr, "%s%s%s%s%s%s%s%s%s%s",
E 2
"usage: mpuoverdub [flags] mpu_data_file ... > mpu_data_file\n",
"flags:\n",
"\t-rN\trepeat all files N times\n",
"\t-w\tdon't wait for [RETURN] to start\n",
"\t-m\tturn on MPU metronome, no accent\n",
"\t-M\tturn on MPU metronome, with accent\n",
"\t-BN\tset number of beats per measure to N\n",
I 2
"\t-BN\tset mpu internal timebase to 48, 72, 96, 120, 144, 168, 192\n",
E 2
"\t-tN\tset tempo to N beats per minute\n",
"\t-cS\tsend configuration file S to MPU\n"
);
exit(ex);
}
E 1
