#include <stdio.h>
#include <midi.h>
#d transform(m) TransformMpuCmd(m,a,b,A,B)

#include <sys/ioctl.h>
#include <mpuvar.h>

PutNote(midi, track, chan, pitch, velocity)
/*
** Start a note playing with the given 'pitch' and 'velocity'
** on 'track' ('0-7') on the 'midi' device.
** 'velocity=0' means "note off".
** 'midi' is the file descriptor for the MPU-401 device.
** The note is played instantaneously, and has no time tag.
** This routine uses the 'MPU_WANT_TO_SEND_DATA' feature
** of the MPU-401 to transmit MIDI data independent of
** time schedules (ie, just poke MIDI data down the pipe
** without time tags).  Similar functions could be written
** to transmit program changes, after touch, etc;
** see sec. 5.9 of the MPU-401 manual.
*/
{
	static unsigned char s[4] = {0, CH_KEY_ON, 0, 0};
	s[0] = MPU_WANT_TO_SEND_DATA + track;
	s[1] = CH_KEY_ON + chan;
	s[2] = (unsigned char) pitch;
	s[3] = (unsigned char) velocity;
	MpuSetTrack(midi,MPU_TR_COM);
	write(midi,s,4);
	MpuSetTrack(midi,track);
}

FILE *
Open(s){
	FILE *f = sopen(s,"r");
	return f? f : OpenTune(s);
}

pitch(s) char *s; { return (*s >= '0' && *s <= '9')? atoi(s) : ptoi(s); }

main(ac,av) char *av[]; 
{
	Int i=1, a=dx7_MIN, b=dx7_MAX, A=dx7_MAX, B=dx7_MIN, midi;
	FILE *Midi;
	MpuCmd *m=Alloc(MpuCmd);
	int track = 0, chan=1;

	for_each_argument {
	Case 'r': a = pitch(argument); b = pitch(argument);
		  A = pitch(argument); B = pitch(argument);
	Case 'R': a = pitch(argument); b = pitch(argument);
		  B = a; A = b;
	Case 'c': chan = atoi(argument)-1;
	Case 't': track = atoi(argument)-1;
	Default: MidiError("%s [-r a b A B] [-R a b] [files or stdin]\n", av0);
       		 MidiError("e.g., '%s -R 60 72' means 'reflect notes in the middle octave\n",av0);
		 exit(1);
	}
	if ((midi = open(MidiDevice, 2)) == -1)
		MidiError("%s can't open %s\n", av0, MidiDevice);
#d mp(x) MpuSet(MPU_/**/x)
	mp(RESET), mp(BENDER_ON), mp(MIDI_THRU_OFF), mp(START_RECORD);
	Midi = fdopen(midi,"r+"); setbuf(Midi,NULL);
	MpuFlush(midi);
	while (!iwait(0,0))
	    while(iwait(midi,0) && GetMpuCmd(Midi,m)){
		if (!IsNote(m)) continue;
		transform(m);
		PutNote(midi, track, chan, MpuPitch(m), MpuVelocity(m));
	    }
	close(midi);
	dx7_reset(-1);
	exit(0);
}
