/* dx7_reset.c	1.2	(CARL)	3/28/85	16:35:50 */

# include <stdio.h>
# include <signal.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

/*
 * dx7_reset -	end-game or interrupt-level reset of dx7
 * requires:
 * 	from setup_cmds.c:
 * 	extern int 	set_cnt()	- set position of next byte in buffer
 * 	extern int 	get_cnt()	- report position in buffer
 * 	extern int 	setup_cmds()	- put byte in buffer
 */


dx7_reset(sig)
	int sig;
{
	u_char mpu_rst[];
	char	*mpu =	MPU_DEV_0;
	register int	cnt, mpu_fd;
	int 		track;

	/* open for reading and writing */
	if ((mpu_fd = open(mpu, 2)) == -1) {
		perror("dx7_reset:open");
		exit(10);
	}
	set_cnt(0);
	setup_cmds(mpu_rst, 0xff);		/* reset mpu */
	dx7_clear(mpu_rst);		/* reset dx7's */
	cnt = get_cnt();

	track = MPU_TR_COM;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1) {
		perror("dx7_reset:ioctl");
		exit(11);
	}
	if (write(mpu_fd, mpu_rst, cnt) != cnt) {
		perror("dx7_reset:write");
		exit(12);
	}
	close(mpu_fd);

	if (sig != -1)
		exit(1);
}

