h61477
s 00000/00023/00054
d D 1.2 85/03/28 16:35:50 dgl 2 1
c 
e
s 00077/00000/00000
d D 1.1 84/12/21 11:36:34 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <signal.h>
# include <sys/types.h>
# include <sys/ioctl.h>
# include <sundev/mpuvar.h>
# include <carl/carl.h>
# include <carl/midi.h>
# include <carl/mpu.h>

/*
 * dx7_reset -	end-game or interrupt-level reset of dx7
 * requires:
 * 	from setup_cmds.c:
 * 	extern int 	set_cnt()	- set position of next byte in buffer
 * 	extern int 	get_cnt()	- report position in buffer
 * 	extern int 	setup_cmds()	- put byte in buffer
 */


dx7_reset(sig)
	int sig;
{
	u_char mpu_rst[];
	char	*mpu =	MPU_DEV_0;
	register int	cnt, mpu_fd;
	int 		track;

	/* open for reading and writing */
	if ((mpu_fd = open(mpu, 2)) == -1) {
		perror("dx7_reset:open");
		exit(10);
	}
	set_cnt(0);
	setup_cmds(mpu_rst, 0xff);		/* reset mpu */
	dx7_clear(mpu_rst);		/* reset dx7's */
	cnt = get_cnt();

	track = MPU_TR_COM;
	if (ioctl(mpu_fd, MPU_IOC_TRACK, &track) == -1) {
		perror("dx7_reset:ioctl");
		exit(11);
	}
	if (write(mpu_fd, mpu_rst, cnt) != cnt) {
		perror("dx7_reset:write");
		exit(12);
	}
	close(mpu_fd);

	if (sig != -1)
		exit(1);
}

D 2
dx7_clear(mpc)
	u_char mpc[];
{
	register int i;

	for (i = 0; i < 16; i++)
		dx7_clear_chan(mpc, i);
}

dx7_clear_chan(mc, chan)
	u_char mc[];
	int chan;
{
	(void) setup_cmds(mc, MPU_SEND_SYSTEM_MESSAGE);
	(void) setup_cmds(mc, 0xf0);
	(void) setup_cmds(mc, 0x43);
	(void) setup_cmds(mc, 0x10 | chan);
	(void) setup_cmds(mc, 0x08);
	(void) setup_cmds(mc, 0x40);
	(void) setup_cmds(mc, 0x00);
	(void) setup_cmds(mc, 0xf7);
}

E 2
E 1
