/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/file.h>
#include <sys/types.h>
#include <carl/midi.h>

open_midi(dev, flags)
	char *dev;
	int flags;
{
	int fid;

	if ((fid = open(dev, flags, 0644)) < 0) {
		perror("open");
		return(-1);
	}
	setraw(fid);
	fid = fid;
	return(fid);
}

close_midi(fid)
	int fid;
{
	clrraw(fid);
	close(fid);
	return(0);
}

midi_out(fid, c)
	int fid;
	u_char c;
/*
 * Write a midi command, 'c', to the MIDI device, 'fid'.
 * Return '0' if successful, '-1' if not.
 */
{
	if (write(fid, &c, sizeof(c)) != sizeof(c)) {
		perror("write");
		return(-1);
	}
	return(0);
}

midi_in(fid)
	int fid;
/*
 * Read a midi command from 'fid' and return it,
 * or '-1' if there was a problem.
 */
{
	u_char c;

	if (read(fid, &c, sizeof(c)) != sizeof(c)) {
		perror("read");
		return(-1);
	}
	return(c);
}
