h28027
s 00063/00000/00000
d D 1.1 84/12/20 17:12:48 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <sys/time.h>
# include <sys/types.h>


/*
 * select2 -	wait to read fd1 or fd2 or timeout
 * takes:
 * 	fd1, fd2 -	unix file descriptors
 * 	time -		time in seconds for timeout
 * returns:
 * 	first fd to be available for reading, or first fd specified if both
 * 	are available.
 * notes:
 * 	returns 0 if timeout interval elapsed with no input from
 * 	either fd; -1 on errors from select().
 */

select2(fd1, fd2, time)
	int fd1, fd2; 
	u_long time;
{
	register int n; 
	int readfds;
	struct timeval timeout;

	timeout.tv_sec = time;
	timeout.tv_usec = 0;
	readfds = 1 << fd1;
	readfds |= 1 << fd2;
	n = select(sizeof(int)*8, &readfds, (int *)0, (int *)0, &timeout);
	if (n <= 0)
		return(n);	/* error, or timeout with nothing to read */
	if (readfds & 1 << fd1)
		return(fd1);
	else if (readfds & 1 << fd2)
		return(fd2);
	else
		return(-1);	/* impossible */
}


/*
 * main()
 * {
 * 	int fd = open("/dev/tty", O_RDWR);
 * 
 * 	if (fd < 0) {
 * 		perror("open");
 * 		exit(1);
 * 	}
 * 
 * 	/1* setraw(fd); *1/
 * 	while (!keypressed())
 * 		continue;
 * 
 * 	/1* clrraw(fd); *1/
 * 	printf("!\n");
 * 	exit(0);
 * }
 */
E 1
