h39445
s 00066/00000/00000
d D 1.1 84/12/20 17:11:34 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <setjmp.h>
# include <signal.h>
# include <sys/time.h>
# include <math.h>

static jmp_buf	jbuf;

/*
 * fsleep -	floating point sleep routine
 * takes:
 * 	interval -	time in real seconds, including fractional time,
 * 	precise down to microseconds, accurate only to system
 * 	clock rate
 * note:
 * 	Depends on 4.2bsd.
 *	preferred over sleep() because of the ability to specify
 *	fractions of seconds.
 */

fsleep(interval)
	float interval;
{
	extern void catchalarm();
	struct itimerval val, oval;
	register long tmp;

	signal(SIGALRM, catchalarm);

	if (setjmp(jbuf))
		return;

	val.it_interval.tv_sec = 0;
	val.it_interval.tv_usec = 0;
	val.it_value.tv_sec = tmp = interval;
	val.it_value.tv_usec = (interval - tmp) * 1000000.0;

	setitimer(ITIMER_REAL, &val, &oval);

	pause();
}

void
catchalarm() 
{
	longjmp(jbuf, 1);
}

/*
 * main(argc, argv)
 * 	char **argv;
 * {
 * 	extern char *ctime();
 * 	struct timeval timeval; 
 * 	struct timezone timezone;
 * 	printf("!\n");
 * 	if (argc > 1) {
 * 		gettimeofday(&timeval, &timezone);
 * 		printf(ctime(&timeval.tv_sec));
 * 		isleep(atof(argv[1]));
 * 		gettimeofday(&timeval, &timezone);
 * 		printf(ctime(&timeval.tv_sec));
 * 	}
 * }
 */
E 1
