h33280
s 00002/00002/00127
d D 1.2 85/06/03 10:51:40 dgl 2 1
c changed get_ch_ctl_name to get_ctl_name to satisfy the
e
s 00129/00000/00000
d D 1.1 85/05/28 21:46:54 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>

/*
 * da_midi_cmd -	disassemble midi command
 * takes:
 * 	FILE		*fid;		- output file descriptor.
 * 	u_char *	ch;		- command to be disassembled.
 * 	int		synth_type;	- manufacturer's MIDI id. number.
 * side effects:
 * 	prints disassembled command on fid
 * returns:
 * 	0 if ok
 * 	-1 on errors:
 * 		invalid controller index
 * 		invalid command
 * notes:
 * 	This routine is used by mpuda(1carl).
 * 	See the README file in this directory to make modifications
 * 	to add additional synthesizers to the disassembler.
 */

da_midi_cmd(fid, ch, synth_type)
	FILE *fid;
	u_char *	ch;
	int		synth_type;
{
	extern char *midi_pk();
	static	int	mcnt;
	register int i;
	char 	*fmt0 = "%-6s          %s\n",
		*fmt1 = "%-6s[%3d]     %s\n",
		*fmt2 = "%-6s[%3d]=%-4d%s\n",
		*fmt3 = "%-6s[%3d]=%-4d%s %s\n";

	if ((*ch & M_CMD_MASK) != SX_CMD)	/* if not system exclusive */
	    *ch &= M_CMD_MASK;			/* strip off channel number */

	switch (ch[0]) {
		case SX_CMD:	/* system exclusive */
			da_sx(fid, ch);
			break;
		case SX_EOB:	/* end of system exclusive block */
			fprintf(fid, fmt1, "eob", ch[1], "system end of block");
			break;
		case SC_MSEL:	/* system common measure select */
			fprintf(fid, fmt0, "msel", "system common measure select");
			break;
		case SC_SSEL:	/* system common song select */
			fprintf(fid, fmt0, "ssel", "system common song select");
			break;
		case SC_TSEL:	/* system common tune request */
			fprintf(fid, fmt0, "tsel", "system common tune request");
			break;
		case RT_TCIP:	/* timing clock in play */
			fprintf(fid, fmt0, "tcip", "timing clock in play");
			break;
		case RT_TCWME:	/* timing clock with measure end */
			fprintf(fid, fmt1, "tcwme", mcnt++, 
				"timing clock with measure end");
			break;
		case RT_SA1M:	/* start at first measure */
			fprintf(fid, fmt0, "sa1m", "start at first measure");
			break;
		case RT_CONT:	/* continue start */
			fprintf(fid, fmt0, "cont", "continue start");
			break;
		case RT_TCIS:	/* timing clock in stop */
			fprintf(fid, fmt0, "tcis", "timing clock in stop");
			break;
		case RT_RESET:	/* system reset */
			fprintf(fid, fmt0, "reset", "system reset");
			break;
		case CH_POLY_KPRS:	/* polyphonic key pressure */
			fprintf(fid, fmt2, "polykp", ch[1], 0, midi_pk(ch[1]), 
				"polyphonic key pressure");
			break;
		case CH_KEY_OFF:	/* channel key off */
			fprintf(fid, fmt2, "koff", ch[1], 0, midi_pk(ch[1]), 
				"key off");
			break;
		case CH_KEY_ON:		/* channel key on */
			if (ch[2] == 0)
				fprintf(fid, fmt3, "koff", ch[1], 0, 
					midi_pk(ch[1]), "key 0 vel.");
			else
				fprintf(fid, fmt3, "kon", ch[1], ch[2], 
					midi_pk(ch[1]), "key on");
			break;
		case CH_CTL:		/* channel control */
			{
D 2
				extern char *get_ch_ctl_name();
E 2
I 2
				extern char *get_ctl_name();
E 2
				register char *par_name;
D 2
				par_name = get_ch_ctl_name(fid, synth_type, 
E 2
I 2
				par_name = get_ctl_name(fid, synth_type, 
E 2
				    ch[1]);
				if (par_name != NULL)
				    fprintf(fid,  fmt2, "ctrl", ch[1], ch[2],
					par_name);
				else
				    fprintf(fid, "%s %d %s %d\n",
					"no such controller index =",
					ch[1],
					"for synth id =",
					synth_type);

			}
			break;
		case CH_PRG:		/* channel program select */
			fprintf(fid, fmt1, "progc", ch[1], "program");
			break;
		case CH_PRESSURE:	/* channel pressure */
			fprintf(fid, fmt1, "press", ch[1], "channel pressure");
			break;
		case CH_P_BEND:		/* channel pitch bend */
			fprintf(fid, "%-6s[%5d]     %s\n", 
				"pbend", (ch[2] << 7) | ch[1], 
				"pitch bend");
			break;
		default:
			fprintf(fid, "%s= %2x %2x %2x\n",
				"da_midi_cmd: unknown command:",
				ch[0], ch[1], ch[2]);
			return(-1);
	}
	return(0);
}
E 1
