#include <stdio.h>
#include <sundev/mpuvar.h>
#include <carl/libcarlmidi.h>

#define set MpuSet
#define mpu(x) set(MPU_/**/x)

MidiPlayInit(file, fd, numtracks, mode)
	char *file;
	int fd[], numtracks, mode;
/*
** Initialize midi device for playing on some number of tracks.
** If 'file' is given, it contains ascii initialization commands
** which are written to the device.
** Otherwise a default sequence is sent (set track 0, clear play, 'mode').
** The open midi file descriptor is returned,
** or 0 if there was an error.
** 'fd[]' is an array of 'numtracks' file descriptors containing midi data;
** Small chunks of data must be pre-written to prime the tracks.
** 'numtracks' tells how many of the 8 available midi tracks
** will be used.
** 'mode' is one of: 'MPU_START_PLAY', 'MPU_START_RECORD',
** or 'MPU_START_OVERDUB'.
** Note that 'MidiPlayInit' does
** an 'MPU_START_mode' (so don't wait too long before transmitting
** play buffers).
** See '/usr/midi/src/bin/play.c" for example of use.
*/
{
#define error return perror(MidiDevice),0
	int f = open(MidiDevice,2);
	register i, tracks=0;
	if (f == -1) error;

	if (numtracks == 0) numtracks = 1;
	for (i=0; fd && fd[i] && i<numtracks; i++) {
	   char s[32]; int n = read(fd[i],s,sizeof s);
	   tracks |= (1<<i);
	   if (MpuSetTrack(f,i) == -1 || write(f,s,n)!=n) error;
	   if (n < sizeof s) close(fd[i]), fd[i] = -1;
	}
	/* send initialization sequence */
	if (file) {
		int d;
		FILE *i = sopen(file,"r");
		if (!i) Error(file);
		while (fscanf(i,"%x",&d) == 1) set(d);
		sclose(i);
		MpuSetTrack(f,MPU_TR_COM), MpuFlush(f);
	} else	/* default initialization sequence */
		MpuSend(f,
		   MPU_ACTIVE_TRACKS, tracks,
		   MPU_CLEAR_PLAY_COUNTERS,
		   MPU_BENDER_ON,
		   mode==0? MPU_START_PLAY : mode,
		   0);

	if (MpuSetTrack(f,0) == -1) error;
	return f;
}
