/* send_dx7_pc.c	1.1	(CARL)	12/21/84	11:06:51 */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

/*
 * send_dx7_pc -	send parameter change
 * takes:
 *	fid   - unix file id
 * 	group -	parameter group number
 * 		0 - 32 (n == 0; Common DX voice parameter, g == 2;
 * 		DX7 function parameter)
 * 	chan -	midi channel
 * 		0 - 16 (n == 0; ch1)
 * 	par -	parameter number
 * 		0 - 65535 (presumably addresses absolute parameter memory)
 * 	data -	parameter data
 * 		0 - 127
 * returns:
 * 	-1 on errors, 0 otherwise, errs = EOF on write.
 */

send_dx7_pc(fid, group, chan, par, data)
	int	fid;
	u_char	group;
	u_char	chan;
	u_short	par;
	u_char	data;
{
	if (midi_out(fid, SX_CMD) == EOF)
		return(dx7_out_err("midi_pc", -1));
	if (midi_out(fid, ID_DX7) == EOF)
		return(dx7_out_err("midi_pc", -1));
	if (midi_out(fid, SX_DX7_PC << 4 | (chan & M_CHAN_MASK)) == EOF)
		return(dx7_out_err("midi_pc", -1));
	/* group and bits 14 - 15 of parameter address */
	if (midi_out(fid, (group | ((par >> 14) & 0x03)) & M_VAL_MASK) == EOF)
		return(dx7_out_err("midi_pc", -1));
	/* bits 7 - 13 of parameter */
	if (midi_out(fid, (par >> 7) & M_VAL_MASK) == EOF)
		return(dx7_out_err("midi_pc", -1));
	/* bits 0 - 6 of parameter */
	if (midi_out(fid, par & M_VAL_MASK) == EOF)
		return(dx7_out_err("midi_pc", -1));
	/* parameter data */
	if (midi_out(fid, data & M_VAL_MASK) == EOF)
		return(dx7_out_err("midi_pc", -1));
}
