h55550
s 00074/00000/00000
d D 1.1 85/05/31 16:16:41 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

#define range(x, base, len) (x >= base && x < base + len)
# define NDOUBLES (27)

sx_dx7_32v(fid, ch)
	FILE *fid;
	u_char *	ch;
{
	register int	b,
			i,
			j,
			k,
			l,
			m,
			opct;
	int 		check_sum = 0; 
	register u_char	val;

	for (k = 0, m = 0; k < DX7NVOX; k++, m++) {
	    fprintf(fid, "\t; voxname[%3d]=\t", k);
	    for (i = 0; i < VOX_NAME_LEN; i++)
		fprintf(fid, "%c", ch[6 + m + VOX_32V_NAME_BASE + i]);
	    fprintf(fid, "\n");
	    for (opct = 5, i = 0; i < DX732VOXLEN+NDOUBLES; i++) {
		j = DX7_INI_IND(i);
		b = dx7_32v_vox[j].par_val;
		l = dx7_32v_vox[j].par_ub;
		val = (ch[m + 6] << b) & l;
		if (b == 0) {	/* start of single or compound field */
			check_sum += ch[m + 6];
			fprintf(fid, 
				 (range((m % DX732VOXLEN), 
				    VOX_32V_NAME_BASE, VOX_NAME_LEN))
				     ? "%2x\t; vox    [%3d]=\t%-10c;%s"
				     : "%2x\t; vox    [%3d]=\t%-10d;%s",
				val,
				m % DX732VOXLEN,
				val,
				dx7_32v_vox[j].par_name);
		} else {
			fprintf(fid, 
				(range(m % DX732VOXLEN, 
				    VOX_32V_NAME_BASE, VOX_NAME_LEN))
				     ? "\t; vox    [%3d]=\t%-10c;%s"
				     : "\t; vox    [%3d]=\t%-10d;%s",
				m % DX732VOXLEN,
				val,
				dx7_32v_vox[j].par_name);
		}
		if (dx7_32v_vox[j+1].par_val == 0)
			m++;
		if (j == 0)
			fprintf(fid, "\top[%d]\n", opct--);
		else
			fprintf(fid, "\n");
	    }
	}
	val = ch[DX7COMLEN + 6];
	fprintf(fid, "%2x\t; check-sum=%d", val, val);
	check_sum = 0x80 - (0x7f & check_sum);
	if (val == check_sum)
	    fprintf(fid, "\tvalid check-sum\n");
	else
	    fprintf(fid, "\t%s %x != %x\n",
		"invalid check-sum",
		val,
		check_sum);
}
E 1
