h50897
s 00049/00000/00000
d D 1.1 84/12/21 11:06:27 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <sys/types.h>
#include <carl/midi.h>
#include <carl/dx7.h>

/*
 * da_vdx7(dx)			- disassemble virtual dx7
 * 	struct dx7 *	dx;	- state structure
 * returns:
 * 	nothing
 * side effects:
 * 	prints a disassembly of dx7 state on stdout, including.
 * 		- all keys with velocity > 0 (keys which are "on")
 * 		- control parameters
 * 		- function parameters
 * 		- number of sounding voices (determined from keys down)
 * 		- current program index
 * 		- pitch bend 
 */

da_vdx7(dx)
	struct dx7 *	dx;
{
	register int i;

	printf("cmd[ind]=\t%-10s%-10s%-10s\n", "value", "u_bound", "name");

	for (i = 0; i < DX7KBDLEN; i++)
		if (dx->dx7_kbd_val[i] != 0)
			printf("kbd[%3d]=\t%-10d%-10d%s\n", 
				i, dx->dx7_kbd_val[i], 127, "kbd & velocity");
	for (i = 0; i < dx7_rcv_ctl_len; i++)
		printf("ctl[%3d]=\t%-10d%-10d%s\n", 
			dx7_rcv_ctl[i].par_index,
			dx->dx7_ctl_val[dx7_rcv_ctl[i].par_index],
			dx7_rcv_ctl[i].par_ub,
			dx7_rcv_ctl[i].par_name);
	for (i = 0; i < dx7_ini_fun_len; i++)
		printf("fun[%3d]=\t%-10d%-10d%s\n", 
			dx7_ini_fun[i].par_index,
			dx->dx7_fun_val[dx7_ini_fun[i].par_index],
			dx7_ini_fun[i].par_ub,
			dx7_ini_fun[i].par_name);
	printf("nsv    =\t%-20d%s\n", dx->dx7_nsv, "number of sounding voices");
	printf("prg    =\t%-20d%s\n", dx->dx7_prg_val, "program");
	printf("pbd    =\t%-20d%s\n", dx->dx7_pbd_val, "pitch bend");
}
E 1
