h54325
s 00043/00038/00060
d D 1.3 85/10/24 09:56:58 dgl 3 2
c mpu_trk and mpu_trkp enhancements.
e
s 00010/00117/00088
d D 1.2 85/10/16 14:49:21 dgl 2 1
c split up into several files.
e
s 00205/00000/00000
d D 1.1 85/10/15 16:18:10 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

D 2
/* %M%	%I%	(CARL)	%G%	%U% */

E 2
# include <carl/sa_mpuvar.h>
# include <sys/types.h>
# include <carl/midi.h>
# include <carl/dx7.h>
# include "medit.h"

typedef Player * Pptr;

D 2
Pptr 	P[8];
int	key;
struct mpu_trk mpu_trk[P_TRK];
int	cur_trk;
int	printit;
E 2
I 2
extern Pptr 	P[P_TRK];
extern int	busy[P_TRK];
extern int	key;
extern struct mpu_trk mpu_trk[P_TRK];
I 3
extern struct mpu_trkp mpu_trkp[P_TRK];
E 3
extern int	cur_trk;
extern int	printit;
E 2

I 3
typedef struct mpu_trkp trkpstruct;	

E 3
D 2
M_start() {
	register int	i;
	Pptr	p;
	extern Player track();

	if (mpu_open(0, MPU_MFRAME | MPU_CONTEX) != 0)
		Pexit(1);
	mpu_reset(0);
	/* select playback track */
	if (mpu_set_track(0, MPU_TR_COM) != 0)
		exit(1);
	init_trk(mpu_trk);
	for (i = 0; i < P_TRK; i++) {
		setup_trk(mpu_trk, i, MPU_TRK_LEN);
	}
	for (p = P_to_I(track), i = 0; p != NULL; p = p->p_next, i++) {
		P[i] = p;
		P[i]->pn[0] = i;
	}
	cur_trk = 0;
	printit = 0;
	Pclock = 5000;		/* equals mpu-401 rate */
}

M_ter()
{
	stop_ptm();
	if (mpu_close(0))
		Pexit(5);
	exit(0);
}

keydown()
{
	int	ch;

	if (nb_acia_read(0, &ch) != 0) {
		acia_write(0, ch);
		key = ch;
		return(TRUE);
	} else
		return(FALSE);
}

Player keytest(0)
{
	P_start {
		Wait_for(keydown, CONTINUOUS);
		Return;
	}

	acia_write(0, key);
	switch (key) {
		register int	i, j;
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			cur_trk = key - '0';
			break;
		case 'R':
			mpu_reset(0);
			/* select playback track */
			if (mpu_set_track(0, MPU_TR_COM) != 0)
				exit(1);
		case 'P':
			printit = cur_trk;
			break;
		case 'S':
			Stop(P[cur_trk]);
			break;
		case '.':	/* quit */
			Pexit();
		case 'c':
			Set_p(P[cur_trk], 0L, cur_trk);
			Set_p(P[cur_trk], 1L, 1);
			Start(P[cur_trk]);
			break;
		case 'd':
			dump_trk(mpu_trk[cur_trk]);
			break;
		case 'l':
			list_trk(mpu_trk[cur_trk]);
			break;
		case 'r':
			mpu_trk[cur_trk].trk_cnt =
			    mpu_record(0,
				mpu_trk[cur_trk].trk_buf,
				mpu_trk[cur_trk].trk_len);
			break;
		case 's':
			Set_p(P[cur_trk], 0L, cur_trk);
			Set_p(P[cur_trk], 1L, 0);
			Start(P[cur_trk]);
			break;
		default:
			break;
	}
}

E 2
Player track(0, Forever, P_STOPPED, P_TRK)
{
	Instance int	pos, cnt, len, sequence;
	Instance u_char	*pla_buf;
	Instance int	ct;
I 3
	Instance trkpstruct tp;
E 3
	unsigned char	cmd_buf[4]; 
	int		i, n;

	P_start {
		sequence = -1;
D 2
		ct = P0;
		if (printit == 1)
			fprintf(1, "ct=%d\n", ct);
E 2
	}

start:	if (sequence < 0) {
I 2
D 3
		ct = P0;
		busy[ct] = 1;
E 3
I 3
		ct = P0;			/* index of track buffer */
		fprintf(1, "(%d", P2);
E 3
E 2
		if (mpu_trk[ct].trk_cnt == 0) {
			printf("empty track\n");
			Stop(Self);
			Return;
		}
		pla_buf = mpu_trk[ct].trk_buf;
		cnt	= mpu_trk[ct].trk_cnt;
I 3
		init_trkp(&tp, &mpu_trk[ct]);
E 3
		pos	= 0;
		sequence = 0;
D 3
		rewind_trk(&mpu_trk[ct]);
E 3
I 3
		busy[P2] = 1;			/* say we're busy */
E 3
	}

D 3
again:	if (sequence == 0) {
		if (pos >= cnt) {	/* all done? */
I 2
			busy[ct] = 0;
E 3
I 3
again:	if (sequence == 0) { /* figure out next note */
		register int	next = 0, p;
		while ((len = next_cmd(&tp)) > 0) {
			pos = p = tp.trkp_pos;
			if (pla_buf[p] == 0xf8)
				next += 240;
			else if (pla_buf[p+1] == 0xf9)
				/* add f9 timetag, but skip playing it */
				next += pla_buf[p];
			else {
				next += pla_buf[p];
				break;
			}
		}
		if (len < 0) {
			fprintf(1, "track: error\n");
			len = 0;
		}
		if (len == 0) {
			sequence = -1;
			if (P1 != 0)
				goto start;
E 3
E 2
			Stop(Self);
I 3
			fprintf(1, "%d)", P2);
			busy[P2] = 0;
E 3
			Return;
D 3
		} else {		/* figure out next note */
			register int	next = 0, p;
			while ((len = next_cmd(&mpu_trk[ct])) > 0) {
				pos = p = mpu_trk[ct].trk_pos;
				if (pla_buf[p] == 0xf8)
					next += 240;
				else if (pla_buf[p+1] == 0xf9)
					/* add f9 timetag, but skip playing it */
					next += pla_buf[p];
				else {
					next += pla_buf[p];
					break;
				}
			}
			if (len < 0) {
				fprintf(1, "track: error\n");
				len = 0;
			}
			if (len == 0) {
				sequence = -1;
				if (P1 != 0)
					goto start;
				Stop(Self);
				Return;
			}
			if (printit == 1)
				fprintf(1, "%d next=%d\n", ct, next);
			Wait_until(Now + next);
E 3
		}
I 3
		if (printit == 1)
			fprintf(1, "%d next=%d\n", ct, next);
		Wait_until(Now + next);
E 3
		sequence = 1;
	} else {
		/* copy command */
D 3
		cmd_buf[0] = 0xd0 | ct;
E 3
I 3
		cmd_buf[0] = 0xd0;
E 3
		if (printit == 1)
			fprintf(1, "%d\t", ct);
D 2
		cmd_buf[1] = (pla_buf[pos+1] & 0xf0) | ct;
E 2
I 2
D 3
		cmd_buf[1] = (pla_buf[pos+1] & 0xf0);
E 3
I 3
		cmd_buf[1] = (pla_buf[pos+1] & 0xf0) | ct;
E 3
E 2
		for (i = 2; i < len; i++) {
			cmd_buf[i] = pla_buf[pos+i];	/* channel cmd */
			if (printit == 1) 
				fprintf(1, "%x\t", pla_buf[pos+i] & 0xff);
		}
		if (printit == 1)
			fprintf(1, "\n");
D 3
		if ((n = mpu_write(0, cmd_buf, len)) < 0)
			exit(2);
E 3
I 3
		if (printit == 0) {
			if ((n = mpu_write(0, cmd_buf, len)) < 0) {
				fprintf(1, "mpu_write: %d\n", n);
				Pexit(1);
			}
		}
E 3
		sequence = 0;
		goto again;
	}
}
E 1
