h32584
s 00002/00000/00070
d D 2.2 88/11/01 23:18:15 dgl 4 3
c 
e
s 00013/00013/00057
d D 2.1 85/10/26 23:43:02 dgl 3 2
c changed variable names.
e
s 00025/00016/00045
d D 1.2 85/10/01 16:35:23 dgl 2 1
c numerous changes.
e
s 00061/00000/00000
d D 1.1 85/09/13 14:04:10 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include "debug.h"

/*
 * run_arbiter -	runtime scheduler
 * side effects:
 * 	Fetches next Player instance to run from get_wait().
 * 	Sets Player instance status to P_KILLED if 
 * 		action time >= begin time + duration.
 * 	Updates global time variable Now, and action time of Player.
 * 	Set Player status to P_RUNNING.
 * 	Sets global Player instance pointer Self.
 * 	Calls Player proc.
 */


run_arbiter()
{
D 2
	extern		psleep();
E 2
I 2
	extern Player	*test_wait();
E 2
	register Player *p, z;

	do {
I 2
		if (!Realtime)
			ptimer(0);
E 2
		/* get an active player */
D 2
		while ((p = get_wait()) == NULL) {	/* nobody waiting */
E 2
I 2
		while ((p = test_wait()) == NULL) {	/* nobody waiting */
E 2
			if (wlist == NULL) {  	/* Wait_for list empty? */
D 2
				printf("run_arbiter: exiting\n");
E 2
I 2
				printf("run_arbiter: done.\n");
E 2
				goto out;		/* done */
			}
		}
D 2
		if (p->runstat > P_RUNNING)
E 2
I 2

		/* can we run this one? */
D 3
		if (p->ptime > Now) 		/* wants to run later */
E 3
I 3
		if (p->P_time > Now) 		/* wants to run later */
E 3
			continue;		/* try again */

		p = get_wait();			/* remove it from queue */
D 3
		if (p->runstat > P_RUNNING) 	/* not runnable */
E 3
I 3
		if (p->P_runstat > P_RUNNING) 	/* not runnable */
E 3
E 2
			continue;
D 2
		/* has it run its span? */
		if (p->p_et == P_GT 
		    ? p->ptime > p->beg + p->dur
		    : p->ptime >= p->beg + p->dur) {
			Kill(p);
			continue;
E 2
I 2

D 3
		if (p->dur >= 0) {
E 3
I 3
		if (p->P_dur >= 0) {
E 3
			/* has it run its span? */
D 3
			if (p->p_et == P_GT 		/* too old */
			    ? p->ptime > p->beg + p->dur
			    : p->ptime >= p->beg + p->dur) {
E 3
I 3
			if (p->P_et == P_GT 		/* too old */
			    ? p->P_time > p->P_beg + p->P_dur
			    : p->P_time >= p->P_beg + p->P_dur) {
E 3
				fprintf(1, "run_arbiter: killing %s\n",
D 3
					p->name);
E 3
I 3
					p->P_name);
E 3
				Kill(p);
				continue;
			}
E 2
		}

		/* prepare to run process */
		Self = p;		/* set global who-am-i */
D 3
		p->runstat = P_RUNNING;	/* make this the running proc. */
D 2
		if (p->ptime > Now) {
			while (p->ptime - Now > 0)
				continue;
		} else
			p->ptime = Now;		/* update private time */
E 2
I 2
		p->ptime = Now;		/* update private time */
E 3
I 3
		p->P_runstat = P_RUNNING;	/* make this the running proc. */
		p->P_time = Now;		/* update private time */
E 3
E 2

		/* run process */
D 2
		z = (p->cproc)(Self);	/* call it */
E 2
I 2
D 3
		z = (p->cproc)(Self);
E 3
I 3
		z = (p->P_cproc)(Self);
E 3
E 2

		/* clean up after process */
D 3
		p->icode = 1;		/* set init. flag done */
		if (p->runstat == P_RUNNING) 	/* still running? */
			p->runstat = P_READY;	/* reset status */
E 3
I 3
		p->P_icode = 1;		/* set init. flag done */
		if (p->P_runstat == P_RUNNING) 	/* still running? */
			p->P_runstat = P_READY;	/* reset status */
I 4
		if (p->P_runstat == P_STUNNED)
			Kill(p);
E 4
E 3
		Self = NULL;
	} while (1);
out:	return;
}
E 1
