/* tempo.c	2.1	(CARL)	10/26/85	23:41:04 */

#include <carl/Player.h>

/*
 * Tempo -	compute tempo by integrating a function of time
 * takes:
 * 	tempofun -	function of time, monotonic in X
 * 	abstart -	un-tempo-factored start time
 * 	absdur -	un-tempo-factored duration
 * 	limit -		limit of integration
 * returns:
 * 	tempo factored time
 */

double 
Tempo(tempofun, abstart, absdur, limit)
	register Function *tempofun;
	register double *abstart, absdur, limit;
{
	register double 	dursum=0, 
				x, 
				ub, 
				absend = *abstart + absdur;

	for (x = *abstart; x < absend; x = ub) {
		ub = ceil(x) == x ? x+limit : ceil(x);
		ub = ub > absend ? absend : ub;
		dursum += (ub - x) * tempofun->fyval[(int)x];
	}
	*abstart += absdur;
	return(dursum);
}
