/* %M%	%I%	(CARL)	%G%	%U% */

/* read_stdin.m	2.1	(CARL)	10/26/85	23:47:41 */

extern char *get_note_stmt();
static char *pn[128];

Player
read_stdin()
{
	extern char *CoerceToPname;
	Instance char *line;
	Instance int cnt;
	Instance double beg;
	Instance double dur;
	Instance int done;

	if (done) {
		Player_stat |= P_TER_SET;
		Kill(Self);
		Return;
	}

	do {
		if ((line = get_note_stmt()) == NULL) {
			(void) Kill(Self);
			done = 1;
			break;
		} else {
# ifdef NOTDEF
			if (_Pdebug & (1<<4))
				fprintf(stderr, "line=%s\n", line);
# endif NOTDEF
			cnt = scanargs(line, pn, 128, 0);
# ifdef NOTDEF
			if (_Pdebug & (1<<4)) {
				int i;
				fprintf(stderr, "cnt=%d\n", cnt);
				for (i = 0; i < cnt; i++)
					fprintf(stderr, "pn[%d]=%s\n",
						i, pn[i]);
			}
# endif NOTDEF
			if (!strcmp(pn[0], "ter")) {/* ter statement seen? */
				if (cnt >= 2)
					beg += atof(pn[1]);
				done = 1;
				beg += dur;
				break;
			}
			if (cnt < 4) {
				fprintf(stderr, 
				    "read_stdin: only %d P fields\n", cnt);
			    exit(1);
			}
			if (CoerceToPname != NULL)
				pn[2] = CoerceToPname;
			beg = add_player(pn, cnt);
			dur = atof(pn[3]);
		}
	} while (beg <= Now);
	(void) Wait_until(beg);
}

char buf[BUFSIZ];

char *
get_note_stmt()
{
	char *cp = buf, *note="note", *ter="ter";
	int c, cnt = 0, tcnt = 0;


	while ((c = getchar()) != EOF) {
		if (c == note[cnt]) {
			*cp++ = c;
			cnt++;
		}
		if (cnt == 4)
			break;
		if (c == ter[tcnt])
			*cp++ = c, tcnt++;
		if (tcnt == 3)
			break;
	}

	while ((c = getchar()) != EOF) {
		*cp++ = c;
		if (c == ';') {
			*cp = '\0';
			return(buf);
		}
	}
	return(NULL);
}
