h24521
s 00002/00002/00129
d D 2.1 85/10/26 23:40:40 dgl 3 2
c changed variable names.
e
s 00001/00001/00130
d D 1.2 85/09/20 16:15:37 dgl 2 1
c exit() is now Pexit().
e
s 00131/00000/00000
d D 1.1 84/12/21 12:08:44 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <carl/Player.h>
#include "debug.h"

char *
read_notes(label, fp)
	register char *label; 
	register FILE *fp;
{
	char *buf = NULL;
	register int 	n = strlen(label), 
			i, 
			hit = 0, 
			c;

	if (n == 0) 
		return(NULL);
	/* anchored string search to label */
	while ((c = getc(fp)) != EOF) {
		for (i = 0; c != EOF && c == label[i]; i++) {
			if (i == n-1) {
				hit = 1;
				break;
			}
			c = getc(fp);
		}
		if (hit && (i == n-1) && ((c = getc(fp)) != EOF) && (c == ':'))
			break;
	}
	/* to get here is to hit on the label */
	/* first put the label on the string to return */
	for (i = 0; label[i] != NULL; i++)
		(void) strsav(&buf, label[i]);
	(void) strsav(&buf, ':'); 
	(void) strsav(&buf, ',');
	/* build a string with notes to be saved in it */
	while ((c = getc(fp)) != EOF && isspace(c)) 
		/* empty */ ;
	if (ungetc(c, fp) == EOF)
		return(NULL);
	i = 0;
	while ((c = getc(fp)) != EOF && c != ';') {
		if (isspace(c)) {
			if (i == 0) { 
				(void) strsav(&buf, ','); 
				i++; 
			}
			continue;
		}
		i = 0;
		(void) strsav(&buf, c);
	}
	(void) strsav(&buf, '\0');
	return(buf);
}

strsav(buf, c)
	register char **buf, c;
{
	static int 	cnt, 
			len;

	if (*buf == NULL) {
		if ((*buf = (char *) malloc((unsigned)BUFSIZ)) == NULL)
			malerr("strsav", 1);
		len = BUFSIZ;
		cnt = 0;
	}
	if (cnt >= len) {
		len += BUFSIZ;
		if ((*buf = (char *) realloc(*buf, (unsigned) len)) == NULL)
			malerr("strsav", 1);
	}
# ifdef P_DEBUG
	if (cnt == 0 && _Pdebug & CYCLIST)
		fprintf(stderr, "strsav: buf=%x\n", buf);
# endif P_DEBUG
	(*buf)[cnt++] = c;
	return(cnt);
}

/* 
 * Get_list - return the string form of a labeled cyclic list 
 * takes:
 *	file -	file name
 *	label -	cyclic list label
 * note: 
 *	Does not parse or install cyclic list in symbol table.
 */

char *
Get_list(file, label)
	register char *file, *label;
{
	register char *cnotes;
	register FILE *fp;

	if ((fp = fopen(file, "r")) == NULL) {
		fprintf(stderr, "Get_list: can't open: %s\n", file);
D 2
		exit(1);
E 2
I 2
		Pexit(1);
E 2
	}
	cnotes = read_notes(label, fp);
	(void) fclose(fp);
	return(cnotes);
}

/* 
 * Read_list - read cyclic list statements from a file
 * takes:
 * 	file -	file name
 * 	label -	cyclic list label
 * side effects:
 *	Installs cyclic list on ST_CYCLIST and ST_CYCLABL symbol tables.
 */

Read_list(file, label)
	register char 	*file, 
			*label;
{
D 3
	extern struct noteheader *newid();
E 3
I 3
	extern struct headcl_hcl *newid();
E 3
	register char 	*cnotes = Get_list(file, label);
D 3
	register struct noteheader *h = newid(cnotes);
E 3
I 3
	register struct headcl_hcl *h = newid(cnotes);
E 3

	(void) buildnotes(h, cnotes);
	free(cnotes);
	/* skip over any initial branch nodes */
	nextnot(h);
}
E 1
