h51385
s 00000/00000/00087
d D 2.2 86/01/30 16:35:37 dgl 3 2
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00000/00000/00087
d D 2.1 85/10/26 23:40:51 dgl 2 1
c changed variable names.
e
s 00087/00000/00000
d D 1.1 84/12/21 12:09:08 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

/*
 * scanargs - carve up a character array containing comma- or blank-separated
 * 	arguments.  
 * takes:
 *	args -	string containing un-broken-out argument fields
 *	pn -	array of string pointers to get individual fields
 *	nargs -	maximum # of argument fields to parse
 *	sb -	flag controling semicolon breaks
 * side effects:
 * It puts a pointer to the head of each argument in the
 * array of char *pn, which you pass it.  It puts a NULL (possibly several)
 * at the end of each argument.  It modifies the array args to do this.
 * It quits when it scans more than
 * nargs arguments (which is presumably set to the boundary of pn[]).
 * It returns the number of arguments it found.
 * The sb parameter will, if true, cause semicolons to break the scan,
 * returning the number of fields scanned up to that point.  The global
 * variable scan_rem will then contain a pointer to the remainder
 * of the un-scanned string (it is otherwise NULL).
 * Note: pass the address of the first element of the pn array.
 */

#include <stdio.h>
#include <ctype.h>
#include <carl/dglib.h>

char *scan_rem;

scanargs(args, pn, nargs, sb)
	register char *args;
	register char **pn;
	register int nargs, sb;
{
	register char *c;
	register int trigger = 0, i = 0;

	scan_rem = NULL;
	while (isspace(*args)) args++;
	for (c = args; *c != NULL; c++) {
		if (sb && *c == ';') {
			*c++ = '\0';
			scan_rem = c;
			break;
		}
		if (!isspace(*c)) { 
			if (!trigger) { 
				if (*c == ',') {
					if (i >= nargs)
						break;
					pn[i++] = c;	/* null p field */
					continue;
				}
				if (i >= nargs)
					break;
				pn[i++] = c; 
				trigger++; 
			} else {
				if (*c == ',' || *c == ';') {
					*c = '\0';
					trigger = 0;
				}
			}
		} else {
			*c = NULL; 
			trigger = 0; 
		}
	}
	return(i);
}

/*
 * main(argc, argv)
 * 	char **argv;
 * {
 * 	static char *line="one two, three four; five six;";
 * 	char *pn[32];
 * 	int cnt, i;
 * 
 * 	cnt = scanargs(line, &pn[0], 32, SEMIBREAK);
 * 	for (i = 0; i < cnt; i++)
 * 		printf("%s\n", pn[i]);
 * 	if (scan_rem != NULL)
 * 		printf("scan_rem=%s\n", scan_rem);
 * }
 */
E 1
