h36173
s 00000/00000/00116
d D 2.2 86/01/30 16:35:05 dgl 5 4
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00036/00036/00080
d D 2.1 85/10/26 23:40:20 dgl 4 3
c changed variable names.
e
s 00004/00000/00112
d D 1.3 85/10/14 15:46:35 dgl 3 2
c added copy of n_type, chord_element, n_stop and n_hold to new
c list being built.
e
s 00002/00002/00110
d D 1.2 85/09/20 16:14:54 dgl 2 1
c exit() is now Pexit().
e
s 00112/00000/00000
d D 1.1 84/12/21 12:07:24 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <carl/Player.h>
#include "debug.h"

/*
D 4
 * noteLabToHed -	go from label to noteheader
E 4
I 4
 * noteLabToHed -	go from label to headcl_hcl
E 4
 */

D 4
struct noteheader *
E 4
I 4
struct headcl_hcl *
E 4
noteLabToHed(label)
	register char *label;
{
	register struct hlist *hl;

	if ((hl = lookup(label, AT_CYCLABL)) != NULL)
		return(hl->hl_val.st_cycl);
	return(NULL);
}

char *
noteLabToStr(label)
	register char *label;
{
	register struct hlist *hl;

	if ((hl = lookup(label, AT_CYCLABL)) != NULL)
D 4
		return(hl->hl_val.st_cycl->nid);
E 4
I 4
		return(hl->hl_val.st_cycl->hcl_nid);
E 4
	return(NULL);
}

/*
 * interplist -	interpolate (really append) sublist to Finite State
 * 	Automaton being built
 * takes:
D 4
 * 	h -	noteheader
E 4
I 4
 * 	h -	headcl_hcl
E 4
 * 	label -	label of cyclic list to interpolate
 * returns:
 * 	address of last FSA node interpolated (appended)
 * side effects:
 * 	Interpolates sublist on FSA.
 */

D 4
struct notnod *
E 4
I 4
struct clist_cl *
E 4
interplist(h, label)
D 4
	register struct noteheader *h;
E 4
I 4
	register struct headcl_hcl *h;
E 4
	register char *label; 
{
	extern char *strcpy();
D 4
	extern struct notnod *newnod();
	register struct noteheader *ih;
	register struct notnod *x, *y = NULL; 
E 4
I 4
	extern struct clist_cl *newnod();
	register struct headcl_hcl *ih;
	register struct clist_cl *x, *y = NULL; 
E 4

	/* find the label for the list to be interpolated */
	if ((ih = noteLabToHed(label)) == NULL) {
		fprintf(stderr, "interplist: no such motive:|%s|\n", label);
D 2
		exit(1);
E 2
I 2
		Pexit(1);
E 2
	}
# ifdef P_DEBUG
	if (_Pdebug & CYCLIST)
		fprintf(stderr, "interplist: label=|%s|, raw=|%s|\n", 
D 4
			label, ih->raw);
E 4
I 4
			label, ih->hcl_raw);
E 4
# endif P_DEBUG

	/* copy the labeled list to the one we're building */
D 4
	for (x = ih->nh; x != NULL; x = x->nxtnot ) {
E 4
I 4
	for (x = ih->hcl_nh; x != NULL; x = x->cl_next ) {
E 4
		y = newnod(h);
D 4
		y->f_bcnt = y->f_times = x->f_times;
		y->b_bcnt = y->b_times = x->b_times;
I 3
		y->n_type = x->n_type;
		y->chord_element = x->chord_element;
		y->n_stop = x->n_stop;
		y->n_hold = x->n_hold;
E 3
		if (x->datum != NULL) {
			if ((y->datum = (char *)malloc((unsigned) 
			    strlen(x->datum)+1)) == NULL)
E 4
I 4
		y->cl_fbcnt = y->cl_ftimes = x->cl_ftimes;
		y->cl_bbcnt = y->cl_btimes = x->cl_btimes;
		y->cl_type = x->cl_type;
		y->cl_chord = x->cl_chord;
		y->cl_stop = x->cl_stop;
		y->cl_hold = x->cl_hold;
		if (x->cl_datum != NULL) {
			if ((y->cl_datum = (char *)malloc((unsigned) 
			    strlen(x->cl_datum)+1)) == NULL)
E 4
				malerr("interplist", 1);
D 4
			(void) strcpy(y->datum, x->datum);
E 4
I 4
			(void) strcpy(y->cl_datum, x->cl_datum);
E 4
# ifdef P_DEBUG
			if (_Pdebug & CYCLIST)
D 4
				fprintf(stderr, "interplist:datum=``%s''\n",
					y->datum);
E 4
I 4
				fprintf(stderr, "interplist:cl_datum=``%s''\n",
					y->cl_datum);
E 4
# endif P_DEBUG
D 4
		} else if (x->measure_id != NULL) {
			if ((y->measure_id = (char *)malloc((unsigned) 
			    strlen(x->measure_id)+1)) == NULL)
E 4
I 4
		} else if (x->cl_meas_id != NULL) {
			if ((y->cl_meas_id = (char *)malloc((unsigned) 
			    strlen(x->cl_meas_id)+1)) == NULL)
E 4
				malerr("interplist", 1);
D 4
			(void) strcpy(y->measure_id, x->measure_id);
E 4
I 4
			(void) strcpy(y->cl_meas_id, x->cl_meas_id);
E 4
# ifdef P_DEBUG
			if (_Pdebug & CYCLIST)
D 4
			    fprintf(stderr, "interplist:measure_id=``%s''\n",
				    y->measure_id);
E 4
I 4
			    fprintf(stderr, "interplist:cl_meas_id=``%s''\n",
				    y->cl_meas_id);
E 4
# endif P_DEBUG
		}
D 4
		if (x->f_branch != NULL) {
			register struct notnod *z; 
E 4
I 4
		if (x->cl_fbranch != NULL) {
			register struct clist_cl *z; 
E 4
			register int cnt;

			/* count # nodes to branch back */
D 4
			for (z = x, cnt = 0; z != NULL && z != x->f_branch; 
					z = z->lstnot) 
E 4
I 4
			for (z = x, cnt = 0; z != NULL && z != x->cl_fbranch; 
					z = z->cl_last) 
E 4
				cnt++;
			if (z == NULL) {
				fprintf(stderr, 
				    "interplist: error backpatching!\n");
D 2
				exit(1);
E 2
I 2
				Pexit(1);
E 2
			}
D 4
			for (z = y; z != NULL && cnt; z = z->lstnot, cnt--) 
E 4
I 4
			for (z = y; z != NULL && cnt; z = z->cl_last, cnt--) 
E 4
				/* empty */ ;
D 4
			y->f_branch = z;
			z->b_branch = y;
E 4
I 4
			y->cl_fbranch = z;
			z->cl_bbranch = y;
E 4
		}
	}
	return(y);
}
E 1
