h03815
s 00000/00000/00070
d D 2.2 86/01/30 16:34:49 dgl 3 2
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00021/00021/00049
d D 2.1 85/10/26 23:40:02 dgl 2 1
c changed variable names.
e
s 00070/00000/00000
d D 1.1 84/12/21 12:06:07 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>

/*
 * cmusout - 	print out instance parameters in cmusic note statement format
 * takes:	
 *	x - Player instance template
 * side effects:
 * 	Prints contents of Pn, PSn, and PPn arrays.
 * 		PSn has precedence over Pn, such that if 
 * 		PSq != NULL, contents of PSq is printed instead
 * 		of contents of Pq.
 * 		PPn is printed if != NULL.
D 2
 * 	If cmusout sees reststat == TRUE, it clears reststat, 
E 2
I 2
 * 	If cmusout sees P_reststat == TRUE, it clears P_reststat, 
E 2
 * 		and returns without printing anything.
 * notes: 
 * 	P fields are numbered from 1, not 0.  This feature brought
 * 		to you by cmusic, which was modeled on Music V, 
 * 		which was originally written in Fortran F2 which had 
 * 		arrays dimensioned from 1. (sigh)
 */

cmusout(x)
	register Player *x;
{
	register int i;
	extern char *trimnum();

D 2
	if (x->reststat == TRUE)
		x->reststat = FALSE;
E 2
I 2
	if (x->P_reststat == TRUE)
		x->P_reststat = FALSE;
E 2
	else {
D 2
		if (!x->silent) {
		    for (i = 1; i <= x->hipn; ) {
			    if (i > x->plen)
E 2
I 2
		if (!x->P_silent) {
		    for (i = 1; i <= x->P_hipn; ) {
			    if (i > x->P_plen)
E 2
				    break;
			    switch (i) {
			    case 1: 
D 2
				    if (x->ps[i] != NULL) /* override note */
					    printf("%s", x->ps[i]);
E 2
I 2
				    if (x->P_ps[i] != NULL) /* override note */
					    printf("%s", x->P_ps[i]);
E 2
				    else
					    printf("note"); break;
			    case 2: 
D 2
				    if (x->ps[i] != NULL) /* override time */
					    printf("%s", x->ps[i]);
E 2
I 2
				    if (x->P_ps[i] != NULL) /* override time */
					    printf("%s", x->P_ps[i]);
E 2
				    else
D 2
					    printf("%6.3f", x->pn[i]);
E 2
I 2
					    printf("%6.3f", x->P_pn[i]);
E 2
				    break;
			    case 3: 
D 2
				    if (x->ps[i] != NULL) /* override name */
					    printf("%s", x->ps[i]);
E 2
I 2
				    if (x->P_ps[i] != NULL) /* override name */
					    printf("%s", x->P_ps[i]);
E 2
				    else
D 2
					    printf("%s", x->name); 
E 2
I 2
					    printf("%s", x->P_name); 
E 2
				    break;
			    default: 
D 2
				    if (x->ps[i] != NULL)
					    printf("%s", x->ps[i]);
E 2
I 2
				    if (x->P_ps[i] != NULL)
					    printf("%s", x->P_ps[i]);
E 2
				    else
D 2
					    printf("%6.3f", x->pn[i]);
E 2
I 2
					    printf("%6.3f", x->P_pn[i]);
E 2
			    }
D 2
			    if (x->pp[i] != NULL)
				    printf("%s", x->pp[i]);
			    if (++i <= x->hipn) 
E 2
I 2
			    if (x->P_pp[i] != NULL)
				    printf("%s", x->P_pp[i]);
			    if (++i <= x->P_hipn) 
E 2
				    printf(", ");
		    }
		}
D 2
		if (x->hipn > 0 && !x->silent) 
E 2
I 2
		if (x->P_hipn > 0 && !x->P_silent) 
E 2
			printf(";\n");
	}
}
E 1
