h31086
s 00001/00001/00038
d D 2.2 86/01/30 16:34:40 dgl 5 4
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00002/00002/00037
d D 2.1 85/10/26 23:39:54 dgl 4 3
c changed variable names.
e
s 00004/00001/00035
d D 1.3 85/10/14 15:45:35 dgl 3 2
c returns count of waits checked.
e
s 00009/00018/00027
d D 1.2 85/09/24 16:11:57 dgl 2 1
c removed code to test for P_KILLED, added code to suppress
c call to test routine if associated Player is not runnable.
e
s 00045/00000/00000
d D 1.1 84/12/21 12:05:52 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <stdio.h>
# include <carl/Player.h>

/*
 * check_waits -	traverse linked list of Wait_for decision procedures
 * returns:	
D 2
 *	count of decision procedures invoked (length of list)
E 2
I 2
D 3
 *	nothing
E 3
I 3
 *	count of waits checked
E 3
E 2
 * side effects:	
D 2
 *	If decision procedure returns TRUE,
 * 		sets running status of Player to P_READY,
 * 		schedules Player to run as soon as possible.
 * 	if Player running status is P_KILLED, the Wait_for link
 * 		is removed from the linked list.
E 2
I 2
 * If Player is runnable, and
 * if decision procedure returns TRUE, then
 * 		- sets running status of Player to P_READY,
 * 		- schedules Player to run as soon as possible.
E 2
 */

check_waits()
{
	register struct wait_f *p, *o;
I 3
	register int	cnt = 0;
E 3
D 2
	register cnt = 0;
E 2

D 2
	for (o = p = wlist; p != NULL; cnt++, o = p, p = p->f_next) {
		if (p->f_pp->runstat == P_KILLED) {
			if (p == wlist)
				wlist = p->f_next;
			else
				o->f_next = p->f_next;
			free((char *) p);
			continue;
		}
		if ((p->f_proc)()) {
E 2
I 2
	for (o = p = wlist; p != NULL; o = p, p = p->f_next) {
D 4
		if (p->f_pp->runstat > P_RUNNING)
E 4
I 4
		if (p->f_pp->P_runstat > P_RUNNING)
E 4
			continue;		/* skip unrunnable Players */
		if ((p->f_proc)() == TRUE) {
E 2
D 4
			p->f_pp->runstat = P_READY;
E 4
I 4
			p->f_pp->P_runstat = P_READY;
E 4
D 5
			set_wait(p->f_pp, Now);
E 5
I 5
			set_wait(p->f_pp, Now, P_WF);
E 5
			if (p->f_flag == ONCE) {
				if (p == wlist)
					wlist = p->f_next;
				else
					o->f_next = p->f_next;
				free((char *) p);
			}
		}
I 3
		cnt++;
E 3
	}
I 3
	return(cnt);
E 3
D 2
	return(cnt);
E 2
}
E 1
