h07958
s 00011/00014/00022
d D 2.2 86/01/30 16:34:05 dgl 4 3
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00003/00003/00033
d D 2.1 85/10/26 23:39:28 dgl 3 2
c changed variable names.
e
s 00006/00008/00030
d D 1.2 85/09/26 17:43:18 dgl 2 1
c fiddled with comment.
e
s 00038/00000/00000
d D 1.1 84/12/21 12:04:51 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <carl/Player.h>
#include "debug.h"
#define NULL 0
D 4
/* 
 * Start - set Player instance run status to P_READY
 * takes:
 *	Player instance structure address
 * returns: 
D 2
 * 	previous status as follows
 * 		P_NOSTAT 	0
 * 		P_READY 	1
 * 		P_RUNNING 	2
 * 		P_STOPPED 	3
 * 		P_KILLED 	4
E 2
I 2
 * 	previous status
E 2
 * side effects:
D 2
 *	Sets Player_stat to P_NULL_PTR if no such Player,
 * 	and returns P_NOSTAT.
E 2
I 2
 * 	Sets Player instance running status to P_READY.
 * 	Sets Player instance time to be run to Now.
 * 	Schedules Player instance to run.
 *	If no such Player, sets Player_stat to P_NULL_PTR
 * 		and returns P_NOSTAT.
E 2
 */
E 4

Start(x)
D 4
	register Player *x;
E 4
I 4
	register Player *x;	/* Player instance structure address */
/*
 * Make Player instance runnable immediately.
 * .LP
 * Returns previous instance status.
 * Sets Player instance running status to \fBP_READY\fP.
 * Sets Player instance time to be run to value of \fBNow\fP.
 * Schedules Player instance to run immediately.
 * If no such Player, sets \fBPlayer_stat\fP to \fBP_NULL_PTR\fP
 * and returns \fBP_NOSTAT\fP.
 */
E 4
{
	register unsigned i;

	Player_stat &= ~P_NULL_PTR;
	if (x != NULL) {
D 3
		i = x->runstat;
		x->runstat = P_READY;
		x->ptime = Now;
E 3
I 3
		i = x->P_runstat;
		x->P_runstat = P_READY;
		x->P_time = Now;
E 3
		set_wait(x, Now);
		return(i);
	} else {
		Player_stat |= P_NULL_PTR;
		return(P_NOSTAT);
	}
}
E 1
