h52231
s 00009/00021/00013
d D 2.2 86/01/30 16:33:09 dgl 5 4
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00001/00001/00033
d D 2.1 85/10/26 23:38:56 dgl 4 3
c changed variable names.
e
s 00010/00004/00024
d D 1.3 85/10/14 15:43:01 dgl 3 2
c prettified P_FLOAT code.
e
s 00004/00000/00024
d D 1.2 85/09/30 12:48:11 dgl 2 1
c made type of argument being set conditional on P_FLOAT.
e
s 00024/00000/00000
d D 1.1 84/12/21 12:03:37 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <carl/Player.h>

D 5
/* 
 * Set_beg_time -	set begin time of player 
 * takes:
 *	x -	pointer to Player instance structure
 *	beg -	begin time to set
 * side effects:
 *	Sets Player_stat to P_NULL_PTR if no Player instance data.
E 5
I 5
void Set_beg_time(x, beg)
	register Player *x;	/* pointer to Player instance structure */
	register P_TYPE beg;	/* begin time to set */
/*
 * Set begin time of Player.
 * .LP
 * Sets \fBPlayer_stat\fP to \fBP_NULL_PTR\fP if no Player instance data.
 * \fBP_TYPE\fP is defined as 'double' on machines with
 * floating point, otherwise it is 'long'.
E 5
 */
D 5

D 3
Set_beg_time(x, beg)
	register Player *x;
E 3
I 2
# ifdef P_FLOAT
E 2
D 3
	register double beg;
E 3
I 3
#	define TYPE double
#	define ZERO 0.0
E 3
I 2
# else P_FLOAT
D 3
	register long beg;
E 3
I 3
#	define TYPE long
#	define ZERO 0
E 3
# endif P_FLOAT
I 3


void
Set_beg_time(x, beg)
	register Player *x;
	register TYPE beg;
E 5
E 3
E 2
{
	Player_stat &= ~P_NULL_PTR;
	if (x == NULL) {
		Player_stat |= P_NULL_PTR;
		return;
	}
D 4
	x->beg = beg;
E 4
I 4
	x->P_beg = beg;
E 4
}
E 1
