h23075
s 00010/00029/00034
d D 2.1 86/01/30 16:38:52 dgl 2 1
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00063/00000/00000
d D 1.1 85/11/06 12:29:18 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <carl/Player.h>

D 2
/*
 * Evaluate string as Rhythm cyclic list element.
 * .TP 18
 * Takes:	
 * pointer to string,
 * .TP 18
 * Returns:	
 * duration in seconds at MM60,
 * .TP 18
 * Side effects: 
 * Sets Player_stat 
 * to P_EXPR_ERR if denominator would cause division by 0.
 * .TP 18
 * Notes:	
 * Does nothing with Hold, Stop, or Kill.
 * .TP 18
 * Diagnostics: 
 * "Rhythm: \`\`<expr>'' would cause division by 0",
 * "Rhythm: malformed expression:\`\`<expr>''".
 */

E 2
double Rhythm(str) 
	register char *str;
/*
D 2
 * Evaluate 's' and return duration in seconds at mm=60.
 * Sets 'Player_stat' to 'P_EXPR_ERR' if denominator would cause division by 0.
 * `Note:` Does nothing with 'Hold', 'Stop', or 'Kill'.
 * .TP
 * `Diagnostics:`
 * "Rhythm: `<expr>` would cause division by 0",
 * .br
 * "Rhythm: malformed expression: `<expr>`".
E 2
I 2
 * Evaluate 'str' as \fBRhythm\fP expression, 
 * and return duration in seconds at \fBMM\fP=60.
E 2
 * .LP
I 2
 * Sets \fBPlayer_stat\fP to \fBP_EXPR_ERR\fP if denominator would 
 * cause division by 0.
 * Does not understand \fBHold\fP, \fBStop\fP, or \fBKill\fP.
 * Diagnostics:
 * \fIRhythm: `<EXPR>` would cause division by 0\fR,
 * .br
 * \fIRhythm: malformed expression: `<EXPR>`\fR.
E 2
 */
{
I 2
	extern double do_rhy();
E 2
	extern char *index();
	char *c, *d, save;
	double sum = 0.0;

	Player_stat &= ~P_EXPR_ERR;
	for (c = str, d = index(c, '+'); d != '\0'; d = index(c, '+')) {
		save = *d;
		*d = '\0';
		sum += do_rhy(c);
		*d = save;
		c = d + 1;
		if (*c == '\0') {
			fprintf(stderr, "Rhythm: malformed expression:``%s''",
				str);
			Player_stat |= P_EXPR_ERR;
			return(1.0);	/* return something safe */
		}
	}
	sum += do_rhy(c);
	return(sum);
}
E 1
