h27018
s 00027/00033/00017
d D 2.2 86/01/30 16:32:49 dgl 5 4
c fixed EACH_CHILD bug, Player *x bug, Instance Player *x bug.
e
s 00003/00003/00047
d D 2.1 85/10/26 23:38:41 dgl 4 3
c changed variable names.
e
s 00012/00003/00038
d D 1.3 85/10/14 15:42:20 dgl 3 2
c prettified P_FLOAT code.
e
s 00019/00012/00022
d D 1.2 85/10/07 10:15:12 dgl 2 1
c now handles negative duration properly.
e
s 00034/00000/00000
d D 1.1 84/12/21 12:03:05 dgl 1 0
c original version
e
u
U
f i 
t
T
I 1
/* %M%	%I%	(CARL)	%G%	%U% */

# include <carl/Player.h>
D 5

E 5
D 2
/* 
E 2
I 2
 
D 5
/*
E 2
 * Rel_time - return relative elapsed time
 * takes:
D 2
 *	x -	Player instance structure pointer
E 2
I 2
 * x -	Player instance structure pointer
E 2
 * returns:
D 2
 *	elapsed time, taking the begin time of the player as 0,
E 2
I 2
 * elapsed time, taking the begin time of the player as 0,
E 2
 * 	and a duration expressed as a fraction in the [0,1) interval.
 * notes:
D 2
 *	As the Player calling Rel_time progresses from its stated
 *	begin time to its end time, the value returned by Rel_time
 *	will increase from [0 to 1).
 *	Note, that if the Player's duration is very large (when
 *	the duration is left out in a Player declaration, the duration
 *	is set to the value HUGE), then the value returned from Rel_time
 *	will grow towards 1 very slowly.
E 2
I 2
 * As the Player calling Rel_time progresses from its stated
 * begin time to its end time, the value returned by Rel_time
 * will increase from [0 to 1).
 * If the Player has its duration disabled (by supplying a negative
 * duration value, or by not having specified a duration as an implicit
 * argument), the largest floating point value
 * is substituted.
 * Note, that if the Player's duration is very large, 
 * then the value returned from Rel_time
 * will grow towards 1 very slowly.
E 2
 * side effects:
D 2
 *	Sets Player_stat to P_NULL_PTR if no Player instance data.
E 2
I 2
 * Sets Player_stat to P_NULL_PTR if no Player instance data.
E 2
 */
E 5

D 3
double 
E 3
I 3
D 5
# ifdef P_FLOAT
# 	define TYPE double
#	define ZERO 0.0
# else P_FLOAT
# 	define TYPE long
#	define ZERO 0
E 5
I 5
# ifndef P_FLOAT
E 5
#	define HUGE 0x37777777
# endif P_FLOAT

D 5
TYPE
E 3
Rel_time(x)
	register Player *x;
E 5
I 5
P_TYPE Rel_time(x)
	register Player *x;	/* Player instance structure pointer */
/*
 * Return relative elapsed time of Player instance.
 * .LP
 * Returns elapsed time, taking the begin time of the player as 0,
 * and a duration expressed as a fraction in the [0,1\(mi`epsilon`] interval.
 * Sets \fBPlayer_stat\fP to \fBP_NULL_PTR\fP if no Player instance data.
 * .LP
 * As the Player calling \fBRel_time\fP progresses from its stated
 * begin time to its end time, the value returned by \fBRel_time\fP
 * will go from [0 to 1\(mi`epsilon`].
 * If the Player has its duration disabled (by supplying 
 * \fBForever\fP as a duration value, 
 * or by not having specified a duration as an implicit
 * argument), the largest positive value 
 * is substituted.
 * \fBP_TYPE\fP is defined as double on machines with
 * floating point, otherwise it is long.
 */
E 5
{
I 5
	register P_TYPE tmp;

E 5
	Player_stat &= ~P_NULL_PTR;
	if (x == NULL) {
		Player_stat = P_NULL_PTR;
D 3
		return(0.0);
E 3
I 3
		return(ZERO);
E 3
	}
I 5

E 5
D 2
	return((x->ptime - x->beg) / x->dur);
E 2
I 2
D 3
	if (x->dur < 0)
E 3
I 3
D 4
	if (x->dur < ZERO)
E 3
		return((x->ptime - x->beg) / HUGE);
E 4
I 4
	if (x->P_dur < ZERO)
D 5
		return((x->P_time - x->P_beg) / HUGE);
E 5
I 5
		tmp = HUGE;
E 5
E 4
	else
D 4
		return((x->ptime - x->beg) / x->dur);
E 4
I 4
D 5
		return((x->P_time - x->P_beg) / x->P_dur);
E 5
I 5
		tmp = x->P_dur;
	return((x->P_time - x->P_beg) / tmp);
E 5
E 4
E 2
}
E 1
